package provide TclUtils 1.0

proc TUfillGap { Grid Norm FmT mGap BeG EnD MoD nV bS V1 V2 } {

   upvar $Grid G
   upvar $Norm N

   set GaP [expr $EnD - $BeG]
   if { ($GaP <= 0) || ($GaP > $mGap) } { return [list 0 0] }

   switch -exact -- $FmT {
      HF -
      HB -
      HM {
         set rV [list 0 0 ]
         set Half [expr int($GaP / 2)]
         set StoP [expr $BeG + $Half]
         for { set I $BeG } { $I < $StoP } { incr I } {
            set P [expr ($I % $MoD) * $nV + $bS]
            set N($P) 1.0
            set G($P) $V1
         }
         set BeG $StoP
         for { set I $BeG } { $I < $EnD } { incr I } {
            set P [expr ($I % $MoD) * $nV + $bS]
            set N($P) 1.0
            set G($P) $V2
         }
      }

      LI {
         set A [expr ($V2 - $V1) / double($GaP + 1)]
         set B [expr $V1 - $A * ($BeG - 1)]
         for { set I $BeG } { $I < $EnD } { incr I } {
            set P [expr ($I % $MoD) * $nV + $bS]
            set N($P) 1.0
            set G($P) [expr $A * $I + $B]
         }
         set rV [list $A $B ]
      }
   }
   return $rV
}
