# Convert Dates between Year Day of Year and Month Day Year and vice versa.
#
# INPUTS
#   Input:  The input format:
#           YDM  = input is year month day to convert to year day of year
#           YD.N = input is year day of year to convert to year month day 
#                  where month is expressed as a numeral
#           YD.S = input is year day of year to convert to year month day 
#                  where month is expressed as an abbreviated ascii month 
#           YD.3 = input is year day of year to convert to year month day 
#                  where month is expressed as an abbreviated 3 letter
#                  ascii month 
#           YD.L = input is year day of year to convert to year month day 
#                  where month is expressed as a full ascii month 
#  Year  : Input Year
#  Day   : Input Day of Month or Day of Year depending on Input
#  Month : Input Month if Input is YDM
#
# OUTPUT is list which is either [Year Day of Year] or [Year Day Month]
#   depending on Input.  Output is passed back through the calling 
#   procedure

package provide TclUtils 1.0

proc TUdateConv { Input Year Day { Month 1 } } {

   set rV ""
   set aMo [list jan feb mar apr may june july aug sept oct nov dec]
   set bMo [list jan feb mar apr may jun jul aug sep oct nov dec]
   set Mo [list january february march april may june july august \
                september october november december]

# NOTE: In this routine months run from 0 to 11 and day of year begins at
#    0.

   if ![string is digit $Month] {
      set Month [string tolower $Month]
      if { [string index $Month end] == "." } {
         set EnD [expr [string length $Month] - 2]
         set Month [string range $Month 0 $EnD]
      }   
      set mP [lsearch $aMo $Month]
      if { $mP < 0 } { set mP [lsearch $bMo $Month] }
      if { $mP < 0 } { set mP [lsearch $Mo $Month]  }
      if { $mP < 0 } {
         puts stderr "Unknown Month $Month"
	 return $rV
      }
      set Month [expr $mP + 1]
   } 

   if { [TUyearLeap $Year] == 365 } { 
       set dL [list 0 31 59 90 120 151 181 212 243 273 304 334 365]
   } else { set dL [list 0 31 60 91 121 152 182 213 244 274 305 335 366] }

   if [string match YDM $Input] {
      incr Month -1
      set rV [list $Year [expr [lindex $dL $Month] + $Day]]
   } else {
      set Output [lindex [split $Input "."] 1]
      incr Day -1
      set I 0
      while { ($Day >= [lindex $dL $I]) && ($I < 13) } { incr I } 

      set Day  [expr $Day - [lindex $dL [expr $I - 1]] + 1]
      set Month $I
      switch -exact -- $Output {
         N  { set Month $I }
         3  { 
	    set Month [lindex $bMo [expr $I - 1]]
	    set Month [string toupper $Month 0 0]
         }
         S  { 
	    set Month [lindex $aMo [expr $I - 1]]
	    set Month [string toupper $Month 0 0]
         }
         L  { 
	    set Month [lindex $Mo [expr $I - 1]]
	    set Month [string toupper $Month 0 0]
         }
      }
      set rV [list $Year $Day $Month]
   }

   return $rV
}
