package provide TclUtils_C 1.0

#  Random Number Generator + and negative
#
#  Data - out (array)
#  Np   - number of values to generate
#  RnG  - value range
#       - NP or PN positive and negative values
#       - P positive values
#       - N negative values
#  Max  - Maximum generated random number

proc TUdataRnd1 { Data Np RnG {Max 1.0} } {
   global Rnd1Seed

   upvar $Data V

   if ![info exists Rnd1Seed] { set Rnd1Seed 566378 }

   switch -exact -- $RnG {
       NP  -
       PN  {   for { set I 0 } { $I < $Np } { incr I } {
                 set Rnd1Seed [expr (1027 * $Rnd1Seed) % 1048576]
                 set V($I) [expr $Max * $Rnd1Seed / 1048576.0]
                 set Rnd1Seed [expr (1027 * $Rnd1Seed) % 1048576]
                 set SgN [expr $Rnd1Seed / 1048576.0]
                 if { $SgN < 0.5 } { set V($I) -$V($I) }
              }
           }
       P   {   for { set I 0 } { $I < $Np } { incr I } {
                 set Rnd1Seed [expr (1027 * $Rnd1Seed) % 1048576]
                 set V($I) [expr $Max * $Rnd1Seed / 1048576.0]
              }
           }
       N   {   for { set I 0 } { $I < $Np } { incr I } {
                 set Rnd1Seed [expr (1027 * $Rnd1Seed) % 1048576]
                 set V($I) [expr -$Max * $Rnd1Seed / 1048576.0]
              }
           }
   }

   return $V(0)
}
