#  gInFo - Processing Information
#          0:  Beginning X grid position 
#          1:  Ending X grid position 
#          2:  Beginning Y grid position 
#          3:  Ending Y grid position 
#          4:  Number of grids along X
#          5:  Number of grids along Y (= 1 for 1D data)
#          6:  User POINT or BAND method to store X data
#          7:  User POINT or BAND method to store Y data
#          8:  Storage Method ROW or COLUMN
#          9:  IGNORE or KEEP Zeros when averaging 
#         10:  NEW (initialize) and/or ADD ( just add to) grid or  
#              END (normalize) grid.  Order is important since it does 
#              actions in order stated. Order should be NEW:ADD:END
#         11:  Value to set unfilled grids to
#         12:  Set bad data to this value
#         13:  Remove Data below this value
#         14:  Remove Data above this value
#         15:  Data cyclic in X
#         16:  Data cyclic in Y
#         17:  Use LINEAR/LOG scaling to store data in X
#         18:  Use LINEAR/LOG scaling to store data in Y
#
# NOTE:  To plot 1D data you input the Y1 and Y2 array as the same array with
#        a single value which is set to 0.0.  Set yHold to nP so that is value
#        is used for all X values.  Set gInfo(2) to -1, gInfo(3) to 1 and 
#        gInfo(5) to 1.

package provide TclUtils_C 1.0

proc TUdataGrid { nP xHold X1 X2 yHold Y1 Y2 Vv Grid Norm gInFo } {
 
   upvar $Norm N
   upvar $Grid G
   upvar $gInFo gIn
   upvar $Vv V
   upvar $X1 Xa
   upvar $X2 Xb
   upvar $Y1 Ya
   upvar $Y2 Yb

# SET the total number of grids in the matrix

   set TotGrids [ expr $gIn(4) * $gIn(5) ]

set LST 0.0

# SPLIT out the actions to be taken 

   set AcTioN [split $gIn(10) ':']
   set LenA [llength $AcTioN]

# LOOP over the actions and do each in turn

   for { set AcT 0 } { $AcT < $LenA } { incr AcT } {
      switch -exact -- [lindex $AcTioN $AcT] {
         NEW {
            for { set I 0 } { $I < $TotGrids } { incr I } { 
               set G($I) 0.0
               set N($I) 0.0
            }
         }
         ADD {

# THE grid axes can be scaled LOG or LINEAR.  Since we may end up
#   modifying the grid information x or y range because of this, we
#   need to work with a temporary set of values

            for { set I 0 } { $I < 19 } { incr I } { set gI($I) $gIn($I) } 

# IF the X or Y grid axis is log scaled then we need to take the log of the 
#   respective grid axis limits 

            set xLog [string match LOG $gI(17)]
            set yLog [string match LOG $gI(18)]
	    if { $xLog } {
	       set gI(0) [expr log10($gI(0))]
	       set gI(1) [expr log10($gI(1))]
            }
	    if { $yLog } {
	       set gI(2) [expr log10($gI(2))]
	       set gI(3) [expr log10($gI(3))]
            }

# CHECK if the grid axis is increasing or decreasing

            if  { $gI(0) > $gI(1) } { set diRx 0 } else { set diRx 1 } 
            if  { $gI(2) > $gI(3) } { set diRy 0 } else { set diRy 1 } 

# SET up the X and Y grid sizes in the matrix

            set IncX [expr ($gI(1) - $gI(0)) / $gI(4)]
            set IncY [expr ($gI(3) - $gI(2)) / $gI(5)]

# SET the X and Y maximum grid number

            set LastX [expr $gI(4) - 1]
            set LastY [expr $gI(5) - 1]

# SET how the X and Y data are to be stored in the matrix 

            if [string match POINT $gI(6)] { set bX 0 } else { set bX 1 }
            if [string match POINT $gI(7)] { set bY 0 } else { set bY 1 }

# SHOULD be include zeros in the data?

            if [string match IGNORE $gI(9)] { set Zero 1 } else { set Zero 0 }

# Wrapping allows skip 1 entries which do not span the entire data set
#   but repeat over and over.

            if { $xHold < 0 } {
               set xWrap [expr -$xHold]
                set xHold 1
            } else { set xWrap $nP }
            if { $yHold < 0 } {
                set yWrap [expr -$yHold]
                set yHold 1
            } else { set yWrap $nP }

            for { set I 0 } { $I < $nP } { incr I } { 

# DON'T save zero data if we are not supposed.  Don't save data that's outside
#    the set limits

               if { $Zero && ($V($I) == 0.0) } { continue }
               if { ($V($I) < $gI(13)) || ($V($I) > $gI(14)) } { continue }

# SET the the location of the data to grab

               set xI [expr ($I / $xHold) % $xWrap]
               set yI [expr ($I / $yHold) % $yWrap]

# SET the order of the data according to whether the grid is increasing or
#    decreasing in the direction of the data

               if $xLog {
                  if $diRx {
                     set Ax [expr log10($Xa($xI))]
                     set Bx [expr log10($Xb($xI))]
                  } else { 
		     set Ax [expr log10($Xb($xI))] ; 
		     set Bx [expr log10($Xa($xI))] 
		  }
	       } else {
                  if $diRx {
                     set Ax $Xa($xI)
                     set Bx $Xb($xI)
                  } else { set Ax $Xb($xI) ; set Bx $Xa($xI) }
               }

# STORE X data within passed BAND or as a POINT.  Do float first so that
#    edges are properly handled

               set cTmPb [expr ($Ax - $gI(0)) / $IncX ]
               set cTmPe [expr ($Bx - $gI(0)) / $IncX ]
               set cFb 1.0
               set cFe 1.0
               if { $bX == 0 } {
                  set cTmPb [expr ($cTmPb + $cTmPe) / 2.0]
                  if { ($cTmPb < 0.0) || ($cTmPb >= $gI(4)) } { continue }
                  set cTmPe $cTmPb
                  set cBeg [ expr int($cTmPb) ]
                  set cEnd [ expr int($cTmPe) ]
               } else {
                  set NobFrac 0
                  set NoeFrac 0
                  if { $cTmPb < 0.0     } { set cTmPb 0.0 ; set NobFrac 1 }
                  if { $cTmPe >= $gI(4) } { set cTmPe $LastX ; set NoeFrac 1 }
                  if { $cTmPb > $cTmPe  } { continue }
                  set cBeg  [ expr int($cTmPb) ]
                  set cEnd  [ expr int($cTmPe) ]
                  if { $cBeg != $cEnd } {
                    if { $NobFrac == 0 } {
                       set cOL [ expr $gI(0) + ($cBeg + 1) * $IncX ]
                       set cFb [expr ($cOL - $Ax) / $IncX]
                    }
                    if { $NoeFrac == 0 } {
                       set cOL [ expr $gI(0) + $cEnd  * $IncX ]
                       set cFe [expr ($Bx - $cOL) / $IncX]
                    }
                  } 
               } 
               set pcEnd [expr $cEnd - 1]
 
# NOW do the exact same thing but for the Y values associated with the data.

               if $yLog {
                  if $diRy {
                     set aY [expr log10($Ya($yI))]
                     set bY [expr log10($Yb($yI))]
                  } else { 
		     set aY [expr log10($Yb($yI))]
		     set bY [expr log10($Ya($yI))] 
		  }
	       } else {
                  if $diRy {
                     set aY $Ya($yI)
                     set bY $Yb($yI)
                  } else { set aY $Yb($yI) ; set bY $Ya($yI) }
               }

               set rTmPb [expr ($aY - $gI(2)) / $IncY ]
               set rTmPe [expr ($bY - $gI(2)) / $IncY ]
               set rFb 1.0
               set rFe 1.0
               if { $bY == 0 } {
                  set rTmPb [expr ($rTmPb + $rTmPe) / 2.0]
                  if { ($rTmPb < 0.0) || ($rTmPb >= $gI(5)) } { continue }
                  set rTmPe $rTmPb
                  set rBeg [ expr int($rTmPb) ]
                  set rEnd [ expr int($rTmPe) ]
               } else {
                  set NobFrac 0
                  set NoeFrac 0
                  if { $rTmPb < 0.0     } { set rTmPb 0.0 ; set NobFrac 1 }
                  if { $rTmPe >= $gI(5) } { set rTmPe $LastY ; set NoeFrac 1 }
                  if { $rTmPb > $rTmPe  } { continue }
                  set rBeg [ expr int($rTmPb) ]
                  set rEnd [ expr int($rTmPe) ]
                  if { $rBeg != $rEnd } {
                     if { $NobFrac == 0 } {
                        set rOW [ expr $gI(2) + ($rBeg + 1) * $IncY ]
                        set rFb [expr ($rOW - $aY) / $IncY]
                     }
                     if { $NoeFrac == 0 } {
                        set rOW [ expr $gI(2) + $rEnd  * $IncY]
                        set rFe [expr ($bY - $rOW) / $IncY]
                     }
                  } 
               }

               set prEnd [expr $rEnd - 1]

# NOW fill in the matrix.  The fill is done either by stacking the columns to
# form the 1D output matrix or by stacking the rows.

               set F1 $cFb 
               if [string match COLUMN $gI(8)] { 
                  for { set J $cBeg } { $J <= $cEnd } { incr J } { 
                     set Pix [expr int($J * $gI(5) + $rBeg)]
                     set F2 $rFb 
                     for {set K $rBeg} {$K <= $rEnd} { incr K ; incr Pix } { 
                         set Frac [expr $F1 * $F2]
                         set G($Pix) [expr $G($Pix) + $V($I) * $Frac] 
                         set N($Pix) [expr $N($Pix) + $Frac ]
                         if {$K == $prEnd } { set F2 $rFe } else { set F2 1.0 }
                     }
                     if {$J == $pcEnd } { set F1 $cFe } else { set F1 1.0 }
                  }
               } else {
                  for { set J $rBeg } { $J <= $rEnd } { incr J } { 
                     set Pix [expr int($J * $gI(4) + $cBeg)]
                     set F2 $rFb 
                     for {set K $cBeg} {$K <= $cEnd} { incr K ; incr Pix } { 
                         set Frac [expr $F1 * $F2]
                         set G($Pix) [expr $G($Pix) + $V($I) * $Frac] 
                         set N($Pix) [expr $N($Pix) + $Frac ]
                         if {$K == $pcEnd } { set F2 $cFe } else { set F2 1.0 }
                     }
                     if {$J == $prEnd } { set F1 $rFe } else { set F1 1.0 }
                  }
               }
            }
         }
         END {
            for { set I 0 } { $I < $TotGrids } { incr I } { 
               if { $N($I) > 0.0 } { 
                  set G($I) [ expr $G($I) / $N($I) ]
               } else { set G($I) $gI(11) }
            }
         }
      }
   }
}
