# LINE FILTERING ALGORITHMS
#
#  Inputs   Data   :  Data array
#           nP     :  Number of points in data array
#           Filter :  Filter name
#           FOps   :  Relevant Filter Options
#           FData  :  Filtered Data
#
#  Filters:
#     SAVITZKY-GOLAY 
#        Options : FOps(0) - number of past data points to include  
#                : FOps(1) - number of future data points to include  
#                : FOps(2) - order of smoothing polynomial
#     MOVINGWINDOW 
#        Options : FOps(0) - length right or left
#               
#               


package provide TclUtils 1.0

proc TUdataFilter { Data nP Filter FOps FData} {
 
   upvar $Data  D
   upvar $FOps  Op
   upvar $FData fD

   switch -exact -- $Filter {
      SAVITZKYGOLAY {
         set nC [expr $Op(0) + $Op(1) + 1] 
         TUsavgolCoef C $nC $Op(0) $Op(1) 0 $Op(2) 
         FfTConvolve D $nP C $nC CONVOLVE fD 
      }
      MOVINGWINDOW {
         set tL [expr $Op(0) + $Op(1) + 1] 
         for { set I 0 } { $I < $nP } { incr I } {
            set BeG [ expr $I - $Op(0)]
            if { $BeG < 0 } { set BeG 0 }
            set EnD [ expr $I + $Op(1)]
            if { $EnD >= $nP } { set EnD [expr $nP - 1] }
            set Sum 0.0
            for { set J $BeG } { $J <= $EnD } { incr J } {
               set Sum [expr $Sum +  $D($J)]
            }
            set fD($I) [expr $Sum / double($EnD - $BeG + 1)]
         }
      }
      default {
         for { set I 0 } { $I < $nP } { incr I } { set fD($I) $D($I) }
      }
   }
}
