# Coordinate system transformations
#
# INPUTS:  
#      GeI   : array of input cartesian coordinates (X, Y, Z)
#      CoI   : Coordinate system of input data
#      XInfo : array of Transformation matrices which is output from call
#              to TUtimeJulian 
#      GeO   : array of output cartesian coordinates (X, Y, Z)
#      CoO   : Coordinate system of output data
#

package provide TclUtils 1.0

proc TUdataCT { GeI CoI XInfo GeO CoO {nM 0} {Yr 1970} {Dy 1} {Msec 0} } {

   upvar $GeI   In
   upvar $GeO   OuT
   upvar $XInfo xT

   if { (![info exists xT]) || ($nM == 1)} { TUtimeJulian $Yr $Dy $Msec xT 1 }

   switch -exact -- $CoI {
      GEI  {
         switch -exact -- $CoO {
             GEO {  TUmatrixMath xT * In OuT 3 3 3 1 1          }
             GSE {  TUmatrixMath xT * In OuT 3 3 3 1 10         }
             GSM {  TUmatrixMath xT * xT M1  3 3 3 3 19 10  
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
             SM  {  TUmatrixMath xT * xT M1  3 3 3 3 19 10  
                    TUmatrixMath xT * M1 M2  3 3 3 3 28
                    TUmatrixMath M2 * In OuT 3 3 3 1
                 }
             MAG {  TUmatrixMath xT * xT M1  3 3 3 3 37 1  
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
         }
      }
      GEO  {
         switch -exact -- $CoO {
             GEI {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
             GSE {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT * M1 M2  3 3 3 3 10
                    TUmatrixMath M2 * In OuT 3 3 3 1
                 }
             GSM {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT * M1 M2  3 3 3 3 10  
                    TUmatrixMath xT * M2 M1  3 3 3 3 19
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
             SM  {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT * M1 M2  3 3 3 3 10  
                    TUmatrixMath xT * M2 M1  3 3 3 3 19
                    TUmatrixMath xT * M1 M2  3 3 3 3 28
                    TUmatrixMath M2 * In OuT 3 3 3 1
                 }
             MAG {  TUmatrixMath xT * In OuT 3 3 3 1 37         }
         }
      }
      GSE  {
         switch -exact -- $CoO {
             GEI {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 10   
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
             GEO {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 10   
                    TUmatrixMath xT * M1 M2  3 3 3 3 1
                    TUmatrixMath M2 * In OuT 3 3 3 1
                 }
             GSM {  TUmatrixMath xT * In OuT 3 3 3 1 19         }
              SM {  TUmatrixMath xT * xT M1  3 3 3 3 19 28  
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
             MAG {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 10   
                    TUmatrixMath xT * M1 M2  3 3 3 3 1
                    TUmatrixMath xT * M2 M1  3 3 3 3 37
                    TUmatrixMath M1 * In OuT 3 3 3 1
                 }
         }
      }
      GSM  {
         switch -exact -- $CoO {
             GEI {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10   
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath M2 * M3 T1  3 3 3 3
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }
             GE0 {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10   
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath M2 * M3 T1  3 3 3 3
                    TUmatrixMath xT * T1 T2  3 3 3 3 1
                    TUmatrixMath T2 * In OuT 3 3 3 1
                 }
             GSE {  TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath M3 * In OuT 3 3 3 1
                 }
             SM  {  TUmatrixMath xT * In OuT 3 3 3 1 28         }
             MAG {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10   
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath M2 * M3 T1  3 3 3 3
                    TUmatrixMath xT * T1 T2  3 3 3 3 1
                    TUmatrixMath xT * T2 T1  3 3 3 3 37
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }
         }
      }
      SM   {
         switch -exact -- $CoO {
             GEI {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10  
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath xT TRANSPOSE xT M4 3 3 3 3 28   
                    TUmatrixMath M3 * M4 T1  3 3 3 3
                    TUmatrixMath T1 * M2 T2  3 3 3 3
                    TUmatrixMath T2 * In OuT 3 3 3 1
                 }
             GEO {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10  
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath xT TRANSPOSE xT M4 3 3 3 3 28   
                    TUmatrixMath M3 * M4 T1  3 3 3 3
                    TUmatrixMath T1 * M2 T2  3 3 3 3
                    TUmatrixMath xT * T2 T1  3 3 3 3 1
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }

             GSE {  TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath xT TRANSPOSE xT M4 3 3 3 3 28   
                    TUmatrixMath M3 * M4 T1  3 3 3 3
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }
             GSM {  TUmatrixMath xT TRANSPOSE xT M4 3 3 3 3 28   
                    TUmatrixMath M4 * In OuT 3 3 3 1
                 }
             MAG {  TUmatrixMath xT TRANSPOSE xT M2 3 3 3 3 10  
                    TUmatrixMath xT TRANSPOSE xT M3 3 3 3 3 19   
                    TUmatrixMath xT TRANSPOSE xT M4 3 3 3 3 28   
                    TUmatrixMath M3 * M4 T1  3 3 3 3
                    TUmatrixMath T1 * M2 T2  3 3 3 3
                    TUmatrixMath xT * T2 T1  3 3 3 3 1
                    TUmatrixMath xT * T1 T2  3 3 3 3 37
                    TUmatrixMath T2 * In OuT 3 3 3 1
                 }
         }
      }
      MAG  {
         switch -exact -- $CoO {
             GEI {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT TRANSPOSE xT M5 3 3 3 3 37   
                    TUmatrixMath M1 * M5 T1  3 3 3 3
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }
             GEO {  TUmatrixMath xT TRANSPOSE xT M5 3 3 3 3 37   
                    TUmatrixMath M5 * In OuT 3 3 3 1
                 }
             GSE {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT TRANSPOSE xT M5 3 3 3 3 37   
                    TUmatrixMath M1 * M5 T1  3 3 3 3
                    TUmatrixMath xT * T1 T2  3 3 3 3 10
                    TUmatrixMath T2 * In OuT 3 3 3 1
                 }
             GSM {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT TRANSPOSE xT M5 3 3 3 3 37   
                    TUmatrixMath M1 * M5 T1  3 3 3 3
                    TUmatrixMath xT * T1 T2  3 3 3 3 10
                    TUmatrixMath xT * T2 T1  3 3 3 3 19
                    TUmatrixMath T1 * In OuT 3 3 3 1
                 }
             SM  {  TUmatrixMath xT TRANSPOSE xT M1 3 3 3 3 1   
                    TUmatrixMath xT TRANSPOSE xT M5 3 3 3 3 37   
                    TUmatrixMath M1 * M5 T1  3 3 3 3
                    TUmatrixMath xT * T1 T2  3 3 3 3 10
                    TUmatrixMath xT * T2 T1  3 3 3 3 19
                    TUmatrixMath xT * T1 T2  3 3 3 3 28
                    TUmatrixMath T2 * In OuT 3 3 3 1
                 }
         }
      }
   }
}
