package provide TclUtils 1.0

# SOLVES  MATRIX A OPER MATRIX B -> MATRIX C

# A        - Matrix Input
# Action   - Operation
# B        - Matrix Input
# C        - Matrix Output
# Ra       - Rows in Matrix A
# Ca       - Columns in Matrix A
# Rb       - Rows in Matrix B
# Cb       - Columns in Matrix B

proc TUcmatrixMath { rA iA Action rB iB rC iC Ra Ca Rb Cb \
                                               { Oa 0} { Ob 0} { Oc 0 } } {

   upvar $rA rX
   upvar $iA iX
   upvar $rB rY
   upvar $iB iY
   upvar $rC rZ
   upvar $iC iZ

   set T 0.0
   switch -exact -- $Action {
      UNIT {  
         set tE [expr $Ra * $Ca]
         TUmatrixMath rX UNIT rX rZ $Ra $Ca $Ra $Ca $Oa $Ob $Oc
	 TUarrayMath rZ * 0.0 iZ $tE
      }

      TRANSPOSE {  
         TUmatrixMath rX TRANSPOSE rX rZ $Ra $Ca $Ra $Ca $Oa $Ob $Oc
         TUmatrixMath iX TRANSPOSE iX iZ $Ra $Ca $Ra $Ca $Oa $Ob $Oc
      }

      HERMITIAN {   
         set tE [expr $Ra * $Ca]
         TUmatrixMath rX TRANSPOSE rX rZ $Ra $Ca $Ra $Ca $Oa $Ob $Oc
         TUmatrixMath iX TRANSPOSE iX iZ $Ra $Ca $Ra $Ca $Oa $Ob $Oc
	 TUarrayMath iZ * -1.0 iZ $tE
      }

      * {  
         set tE [expr $Ra * $Cb]
         TUmatrixMath rX * rY rTmP $Ra $Ca $Rb $Cb $Oa $Ob $Oc
         TUmatrixMath iX * iY iTmP $Ra $Ca $Rb $Cb $Oa $Ob $Oc
	 TUarrayMath rTmP - iTmP rZ $tE

         TUmatrixMath rX * iY rTmP $Ra $Ca $Rb $Cb $Oa $Ob $Oc
         TUmatrixMath iX * rY iTmP $Ra $Ca $Rb $Cb $Oa $Ob $Oc
	 TUarrayMath rTmP + iTmP iZ $tE
      }
   }

   return $T
}
