# COMPUTES BESSEL FUNCTIONS J0, J1, I0, I1, K0, K1 for real X 

package provide TclUtils 1.0

proc TUbesselFN { fN X }  {
 
   switch -exact -- $fN {
      J0  { set rV [BesselJ 0 $X] }
      J1  { set rV [BesselJ 1 $X] }
      I0  { set rV [BesselI 0 $X] }
      I1  { set rV [BesselI 1 $X] }
      K0  { set rV [BesselK 0 $X] }
      K1  { set rV [BesselK 1 $X] }
   }
   return $rV
}

proc BesselJ { V X } {

   if { $V == 0 } {
      set G     1.0
      set A(0)  57568490574.0  ; set A(1) -13362590354.0
      set A(2)  651619640.7    ; set A(3) -11214424.18
      set A(4)  77392.33017    ; set A(5) -184.9052456
      set B(0)  57568490411.0  ; set B(1)  1029532985.0
      set B(2)   9494680.718   ; set B(3)  59272.64853 
      set B(4)  276.8532712    ; set B(5)  1.0
      set C    0.785398164
      set D(0) 1.0 
      set D(1) -0.1098628627e-2 ; set D(2) 0.2734510407e-4
      set D(3) -0.2073370639e-5 ; set D(4) 0.2093887211e-6
      set E(0) -0.1562499995e-1
      set E(1)  0.1430488765e-3 ; set E(2) -0.6911147651e-5
      set E(3)  0.7621095161e-6 ; set E(4) -0.934935152e-7
      set F     0.636619772 
   } else {
      set G     $X
      set A(0)  72362614232.0  ; set A(1) -7895059235.0
      set A(2)  242396853.1    ; set A(3) -2972611.429
      set A(4)  15704.48260    ; set A(5) -30.16036606
      set B(0)  144725228442.0 ; set B(1)  2300535178.0
      set B(2)   18583304.74   ; set B(3)  99447.43394 
      set B(4)  376.9991397    ; set B(5)  1.0
      set C    2.356194491
      set D(0) 1.0 
      set D(1) 0.183105e-2     ; set D(2) -0.3516396496e-4
      set D(3) 0.2457520174e-5 ; set D(4) -0.240337016e-6
      set E(0) 0.04687499995
      set E(1) -0.2002690873e-3 ; set E(2) 0.8449199096e-5
      set E(3) -0.88228987e-6   ; set E(4) 0.105787412e-6
      set F     0.636619772 
   }

   set aX [expr abs($X)]
   if { $aX < 8.0 } {
      set Y  [expr $X * $X]
      set A1 [expr $G * ($A(0) + $Y * ($A(1) + $Y * ($A(2) + \
                    $Y * ($A(3) + $Y * ($A(4) + $Y * $A(5))))))]
      set A2 [expr $B(0) + \
                    $Y * ($B(1) + $Y * ($B(2) + \
                    $Y * ($B(3) + $Y * ($B(4) + $Y * $B(5)))))]
      set rV [expr $A1 / $A2]
    } else {
       set Z  [expr 8.0 / $aX]
       set Y  [expr $Z * $Z]
       set A0 [expr $aX - $C]
       set A1 [expr $D(0) +  $Y * ($D(1) + $Y * ($D(2) + \
                    $Y * ($D(3) + $Y * $D(4))))]
       set A2 [expr $E(0) +  $Y * ($E(1) + $Y * ($E(2) + \
                    $Y * ($E(3) + $Y * $E(4))))]
       set rV [expr sqrt($F / $aX) * (cos($A0) * $A1 - $Z * sin($A0) * $A2)]
   }
   return $rV
}

proc BesselI { V X } {

   set aX [expr abs($X)]

   if { $V == 0 } {
      set G    1.0
      set A(0) 1.0 
      set A(1)  3.5156229  ; set A(2)  3.0899424  ; set A(3)  1.2067492  
      set A(4)  0.2659732  ; set A(5)  0.0360768  ; set A(6)  0.0045813
      set B(0)  0.39894228 ; set B(1)  0.01328592 ; set B(2)  0.00225319 
      set B(3) -0.00157565 ; set B(4)  0.00916281 ; set B(5) -0.02057706
      set B(6)  0.02635537 ; set B(7) -0.01647633 ; set B(8)  0.00392337
   } else {
      set G     $aX
      set A(0)  0.5 
      set A(1)  0.87890594 ; set A(2)  0.51498869 ; set A(3)  0.15084934  
      set A(4)  0.02658733 ; set A(5)  0.00301532 ; set A(6)  0.00032411
      set B(0)  0.39894228 ; set B(1) -0.03988024 ; set B(2) -0.00362018 
      set B(3)  0.00163801 ; set B(4) -0.01031555 ; set B(5)  0.02282967
      set B(6) -0.02895312 ; set B(7)  0.01787654 ; set B(8) -0.00420059
   }

   if { $aX < 3.75 } {
      set Y  [expr $X * $X / 14.0625]
      set rV [expr $G * ($A(0) + $Y * ($A(1) + $Y * ($A(2) + $Y * ($A(3) + \
                           $Y * ($A(4) + $Y * ($A(5) + $Y * $A(6)))))))]
    } else {
       set Y  [expr 3.75 / $aX]
       set G1 [expr exp($aX) / sqrt($aX)]
       set rV [expr $G1 * ($B(0) + $Y * ($B(1) + $Y * ($B(2) + $Y * \
                          ($B(3) + $Y * ($B(4) + $Y * ($B(5) + $Y * \
                          ($B(6) + $Y * ($B(7) + $Y * $B(8)))))))))] 
       if { $V == 0 } { if { $X < 0 } { set rV [expr -$rV] } }
   }
   return $rV
}

proc BesselK { V X } {

   if { $V == 0 } {
      set bI [BesselI 0 $X]
      set G  [expr -log($X/2.0) * $bI]
      set H  1.0
      set A(0) -0.57721566 ; set A(1)  0.42278420 ; set A(2)  0.23069756
      set A(3)  0.03488590 ; set A(4)  0.00262698 ; set A(5)  0.00010750
      set A(6)  0.00000740
      set B(0)  1.25331414 ; set B(1) -0.07832358 ; set B(2)  0.02189568
      set B(3) -0.01062446 ; set B(4)  0.00587872 ; set B(5) -0.00251540
      set B(6)  0.00053208
   } else {
      set bI [BesselI 1 $X]
      set G  [expr log($X/2.0) * $bI]
      set H  [expr 1.0 / $X]
      set A(0)  1.00000000 ; set A(1)  0.15443144 ; set A(2) -0.67278579
      set A(3) -0.18156897 ; set A(4) -0.01919402 ; set A(5) -0.00110404
      set A(6) -0.00004686
      set B(0)  1.25331414 ; set B(1)  0.23498619 ; set B(2) -0.03655620
      set B(3)  0.01504268 ; set B(4) -0.00780353 ; set B(5)  0.00325614
      set B(6) -0.00068245
   }

   set Y [expr $X * $X / 4.0]
   if { $X < 2.0 } {
      set rV [expr $G + $H * ($A(0) + $Y * ($A(1) + $Y * ($A(2) + $Y * \
                      ($A(3) + $Y * ($A(4) + $Y * ($A(5) + $Y * $A(6)))))))] 
   } else {
      set Y [expr 2.0 / $X]
      set rV [expr exp(-$X) / sqrt($X)]
      set rV [expr $rV * ($B(0) + $Y * ($B(1) + $Y * ($B(2) + $Y * \
                       ($B(3) + $Y * ($B(4) + $Y * ($B(5) + $Y * $B(6)))))))] 
   }
   
   return $rV
}
