/*  A Tcl/C utility routine which takes a TCL array and comverts it into    */
/*  a C array                                                               */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"

ByTe_4 TclArrayToC (Tcl_Interp *tI, Tcl_Obj *V, void *cArray, ByTe_4 N, 
                    ByTe_4 Beg, ByTe_1 aSz) 
{
   register ReaL_8 *dPt;
   ReaL_4 *fPt;
   ByTe_4 *lPt;
   ByTe_2 *sPt;
   ByTe_1 *cPt;

   register ByTe_4 I;
   ByTe_4 Cnt = 0;
   int Flg = TCL_LEAVE_ERR_MSG;

   char *aName, Index[10];
   double V1;
   int    V2;

   Tcl_Obj *rV0;

/* Get the array name                           */

   aName = Tcl_GetString(V); 

/* Put the data into a straight C array         */

   switch (aSz) {
      case 'D':
        dPt = (ReaL_8 *)cArray;
        for (I = 0; I < N; ++I, ++dPt ) {
           sprintf (Index, "%d", Beg++);
           if ((rV0 = Tcl_GetVar2Ex(tI, aName, Index, Flg)) != NULL) {
              Tcl_GetDoubleFromObj (tI, rV0, dPt);
              ++Cnt;
           }
        }
      break;
      case 'F':
        fPt = (ReaL_4 *)cArray;
        for (I = 0; I < N; ++I ) {
           sprintf (Index, "%d", Beg++);
           if ((rV0 = Tcl_GetVar2Ex(tI, aName, Index, Flg)) != NULL) {
              Tcl_GetDoubleFromObj (tI, rV0, &V1);
              fPt[I] = (ReaL_4)V1;
              ++Cnt;
           }
        }
      break;
      case 'L':
        lPt = (ByTe_4 *)cArray;
        for (I = 0; I < N; ++I, ++lPt ) {
           sprintf (Index, "%d", Beg++);
           if ((rV0 = Tcl_GetVar2Ex(tI, aName, Index, Flg)) != NULL) {
              Tcl_GetIntFromObj (tI, rV0, lPt);
              ++Cnt;
           }
        }
      break;
      case 'S':
        sPt = (ByTe_2 *)cArray;
        for (I = 0; I < N; ++I ) {
           sprintf (Index, "%d", Beg++);
           if ((rV0 = Tcl_GetVar2Ex(tI, aName, Index, Flg)) != NULL) {
              Tcl_GetIntFromObj (tI, rV0, &V2);
              sPt[I] = (ByTe_2)V2;
              ++Cnt;
           }
        }
      break;
      case 'C':
        cPt = (ByTe_1 *)cArray;
        for (I = 0; I < N; ++I ) {
           sprintf (Index, "%d", Beg++);
           if ((rV0 = Tcl_GetVar2Ex(tI, aName, Index, Flg)) != NULL) {
              Tcl_GetIntFromObj (tI, rV0, &V2);
              cPt[I] = (ByTe_1)V2;
              ++Cnt;
           }
        }
      break;
   }

   return Cnt;
}
