/*  The C equivalent of TUpolyExp1D,  It consists of a TCL interface over   */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  The X value (X)                                            */
/*     OBJV[2]:  The number of coefficients (nCoef)                         */
/*     OBJV[3]:  The coefficent array                                       */
/*     OBJV[4]:  Offset to start of coefficients (Off)                      */
/*                                                                          */
/*     The resultant Y value is returned through the procedure              */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int PolyExp1DCmd (ClientData cD, Tcl_Interp *interp, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr;
   ReaL_8 *CoeF;
   ReaL_8 X, Lims[2];
   int    nCoef, Off = 0;
   double Y;
   ByTe_4 Bytes, LChk = 0;

   Tcl_Obj *objPtr;

   
/* Make sure that the minimum number of IO parameters are present */

   if (objc < 4 ) {
     Tcl_WrongNumArgs(interp, 1, objv, "Usage: TUpolyExp1D X nCoef Coef");
     return TCL_ERROR;
   }

/* Get the non array input parameters                                       */

   Tcl_GetDoubleFromObj (interp, objv[1], &X);
   Tcl_GetIntFromObj (interp, objv[2], &nCoef);
   if (objc >= 5)
      Tcl_GetIntFromObj (interp, objv[4], &Off);

   if (objc == 7) {
      Tcl_GetDoubleFromObj (interp, objv[5], &Lims[0]);
      Tcl_GetDoubleFromObj (interp, objv[6], &Lims[1]);
      LChk = (Lims[0] == Lims[1]) ? 0 : 1;
   } 


/* Get the array inputs                                                     */

   Bytes = sizeof(ReaL_8) * nCoef;
   if ((memPtr = malloc (Bytes)) == NULL)
      return TCL_ERROR;
   CoeF = (ReaL_8 *)memPtr;
   
   if (TclArrayToC (interp, objv[3], (void *)CoeF, nCoef, Off, 'D') == 0) {
      free (memPtr);
      return TCL_OK;
   }

/* Call the  straight C array procedure                                   */

   Y = PolyExp1D_C (X, nCoef, CoeF, LChk, Lims); 

/* Gather output - free data array - and gone                             */

   free (memPtr);

   objPtr = Tcl_GetObjResult(interp);
   Tcl_SetDoubleObj (objPtr, Y); 
   return TCL_OK;
}

   
ReaL_8  PolyExp1D_C (ReaL_8 X, int N, ReaL_8 *A, ByTe_4 LChk, ReaL_8 *Lims)
{
   ReaL_8 Y, PoW;
   ByTe_4 I;

   PoW = 1.0;
   Y = A[0];
   for (I = 1; I < N; ++I) {
      PoW *= X;
      Y += A[I] * PoW;
   }

   if (LChk == 1) {
      if (Y > Lims[0]) { Y = Lims[0]; }
      if (Y < Lims[1]) { Y = Lims[1]; }
   }

   return (Y);
}
