/*  The C equivalent of TUintegTrap,  It consists of a TCL interface over   */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 6 OBJV elements 5 required.  These are:                       */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  The function which gives V for each X                      */
/*     OBJV[2]:  Begin Integration Point (BegI)                             */
/*     OBJV[3]:  End Integration Point (EndI)                               */
/*     OBJV[4]:  Number of points added since last call when using an       */
/*                  iterative integration approach: 2**(N-2) (N)            */
/*     OBJV[5]:  Previous integration value (used in iterative integration  */
/*                  approach) (pV)                                          */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"

int IntegTrapCmd (ClientData cD, Tcl_Interp *tI, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 pV = 0.0, BegI, EndI, rV;
   int N, OneTime = 0;
   ByTe_1 *FunC, NFunC[100];

   Tcl_Obj *objPtr;

/* Make sure that the minimum number of IO parameters are present          */


   if (objc < 5 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: TUintegTrap FunC B E N ");
      return TCL_ERROR;
   }

/* Get the input parameters                                               */

   FunC = Tcl_GetStringFromObj (objv[1], (int *)0); 
   strcpy(NFunC, FunC);
   Tcl_GetDoubleFromObj (tI, objv[2], &BegI);
   Tcl_GetDoubleFromObj (tI, objv[3], &EndI);
   Tcl_GetIntFromObj (tI, objv[4], &N);
   if (objc >= 6) { Tcl_GetDoubleFromObj (tI, objv[5], &pV); }
   if (objc >= 7) { Tcl_GetIntFromObj (tI, objv[6], &OneTime); }

/* Check N                                                                  */

   if (N < 1) { N = 1; }

/* Call the  straight C array procedure                                     */

   rV = IntegTrap_C (tI, NFunC, BegI, EndI, N, pV, OneTime); 

   objPtr = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (objPtr, rV); 
   return TCL_OK;
}

ReaL_8 IntegTrap_C (Tcl_Interp *tI, ByTe_1 *FunC, ReaL_8 BegI,
                     ReaL_8 EndI, int N, ReaL_8 pV, int OneTime)
{
   ReaL_8 dH, dh, rV;
   ReaL_8 Sum, V, V1, TnM;
   ByTe_4 I = -1, M, J;
   int Flg = TCL_LEAVE_ERR_MSG;
   ByTe_1 NFunC[150], Index[10];
   ByTe_1 *FFmt = "set InTg [%s %le %le %d %d]";
   ByTe_1 *FaFmt = "set InTg [%s %le %le %d -1 OuT]";
   Tcl_Obj *rVO;

   dH = EndI - BegI;
   if (OneTime == 1) {
      if (N == 1) {
         J = 2;
         sprintf (NFunC, FaFmt, FunC, BegI, dH, J);
         Tcl_Eval(tI, NFunC);
         Sum = 0.0;
         for (I = 0; I < J; ++I ) { 
            sprintf(Index, "%d", I);
	    rVO = Tcl_GetVar2Ex(tI, "OuT", Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V1);
            Sum += V1; 
         }
         rV = 0.5 * dH * Sum;
      } else { 
         M = N-1;
         J = 1;
         for (I = 0; I < M; ++I ) { J <<= 1; }
         TnM = (ReaL_8)J;
         dh = dH / TnM; 
         V = BegI + 0.5 * dh;
         sprintf (NFunC, FaFmt, FunC, V, dh, J);
         Tcl_Eval(tI, NFunC);
         Sum = 0.0;
         for (I = 0; I < J; ++I ) { 
            sprintf(Index, "%d", I);
	    rVO = Tcl_GetVar2Ex(tI, "OuT", Index, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V1);
            Sum += V1;
         }
   
         rV = 0.5 * (pV + dH * Sum / TnM);
      }
   } else {
      if (N == 1) {
         J = 2;
         V = BegI;
         Sum = 0.0;
         for (I = 0; I < J; ++I, V += dH ) { 
            sprintf (NFunC, FFmt, FunC, V, dh, J, I);
            Tcl_Eval(tI, NFunC);
	    rVO = Tcl_GetVar2Ex(tI, "InTg", (char *)0, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V1);
            Sum += V1;
         }
         rV = 0.5 * dH * Sum;
      } else {
         M = N-1;
         J = 1;
         for (I = 0; I < M; ++I ) { J <<= 1; }
         TnM = (ReaL_8)J;
         dh = dH / TnM; 
         V = BegI + 0.5 * dh;
         Sum = 0.0;
         for (I = 0; I < J; ++I, V += dh ) { 
            sprintf (NFunC, FFmt, FunC, V, dh, J, I);
            Tcl_Eval(tI, NFunC);
	    rVO = Tcl_GetVar2Ex(tI, "InTg", (char *)0, Flg);
	    Tcl_GetDoubleFromObj (tI, rVO, &V1);
            Sum += V1;
         }
   
         rV = 0.5 * (pV + dH * Sum / TnM);
      }
   }
   return (rV);
}
