/*  A Tcl/C utility routine which takes a C array and comverts it into       */
/*  a Tcl array                                                              */

#include <tcl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ByteDefs.h"

ByTe_4 CArrayToTcl (Tcl_Interp *tI, Tcl_Obj *V, void *cArray, ByTe_4 N, 
                    ByTe_4 Off, ByTe_1 aSz) 
{
   register ReaL_8 *dPt;
   register ReaL_4 *fPt;
   register ByTe_4 *lPt, I;
   register ByTe_2 *sPt;
   register ByTe_1 *cPt;
   register u_ByTe_4 *ulPt;
   register u_ByTe_2 *usPt;
   register u_ByTe_1 *ucPt;

   ByTe_4 Beg;

   int Flg = TCL_LEAVE_ERR_MSG;

   char *aName, Index[10], Value[40];
   Tcl_Obj *rVO;

/* Find the varaible info structure                         */

   aName = Tcl_GetString(V); 

/* New object                                               */

   rVO = Tcl_NewObj();

/* Put the data into a straight C array                     */

   Beg = Off;
   switch (aSz) {
      case 'D':
        dPt = (ReaL_8 *)cArray;
        for (I = 0; I < N; ++I, ++dPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetDoubleObj (rVO, *dPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'F':
        fPt = (ReaL_4 *)cArray;
        for (I = 0; I < N; ++I, ++fPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetDoubleObj (rVO, (double)*fPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'L':
        lPt = (ByTe_4 *)cArray;
        for (I = 0; I < N; ++I, ++lPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetIntObj (rVO, *lPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'S':
        sPt = (ByTe_2 *)cArray;
        for (I = 0; I < N; ++I, ++sPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetIntObj (rVO, (int)*sPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'C':
        cPt = (ByTe_1 *)cArray;
        for (I = 0; I < N; ++I, ++cPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetIntObj (rVO, (int)*cPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'l':
        ulPt = (u_ByTe_4 *)cArray;
        for (I = 0; I < N; ++I, ++ulPt) { 
           sprintf(Index, "%d", Beg++); 
           sprintf(Value, "%d", *ulPt);
           Tcl_SetVar2 (tI, aName, Index, Value, Flg);
        }
      break;
      case 's':
        usPt = (u_ByTe_2 *)cArray;
        for (I = 0; I < N; ++I, ++usPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetIntObj (rVO, (int)*usPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
      case 'c':
        ucPt = (u_ByTe_1 *)cArray;
        for (I = 0; I < N; ++I, ++ucPt) {
           sprintf(Index, "%d", Beg++); 
	   rVO = Tcl_DuplicateObj(rVO);
	   Tcl_SetIntObj (rVO, (int)*ucPt);
	   Tcl_SetVar2Ex(tI, aName, Index, rVO, Flg);
        }
      break;
   }

   return 1;
}
