#  THIS procedure returns a list of two lists.  The first is unit 
#     descriptions and the second the corresponding unit labels for 
#     the input list of pidf unit numbers
#  INPUTS are:
#    KeY:   the udf key to use when getting the sensors
#    Units; list of units
#    nFmt;  use the sensor long (LONG) name or short (SHORT) name for the
#           unit description            

package provide UDFUtils 1.0

proc UUgetUNames { KeY Units nFmt } {
   global Pidf0

# NUMBER of sensor sto process

   set nU [llength $Units]

# GET the PIDF information

   ReadPIDF $KeY

# SET the name we are getting

   if [string match SHORT $nFmt] { set fN UnitSDes } else { set fN UnitLDes }

# GET the Names 

   set uDes ""
   set uLab ""

   for { set I 0 } { $I < $nU } { incr I } {
      set sN [lindex $Units $I]
      lappend uDes [lindex $Pidf0($fN) $sN]
      lappend uLab [lindex $Pidf0(UnitLab) $sN]
   }

   return [list $uDes $uLab]
}
