#  THIS procedure returns a list of senor names for the corresponding list
#    of pidf sensor numbers
#  INPUTS are:
#    KeY:  the udf key to use when getting the sensors
#    Sen:  list of sensors
#    nFmt: get the sensor full (FULL) name or component (COMP) name

package provide UDFUtils 1.0

proc UUgetSNames { KeY Sen nFmt } {
   global Pidf0

# NUMBER of sensor sto process

   set nS [llength $Sen]

# GET the PIDF information

   ReadPIDF $KeY

# SET the name we are getting

   if [string match COMP $nFmt] { set fN SenComp } else { set fN SenName }

# GET the Names 

   set sNames ""

   for { set I 0 } { $I < $nS } { incr I } {
      set sN [lindex $Sen $I]
      lappend sNames [lindex $Pidf0($fN) $sN]
   }

   return $sNames
}
