#  THIS procedure takes an array ASCII entry and converts it into a binary
#    representation

package provide TclUDFdB 1.0

proc DBvidfProcField { fd Store ByTe_4 ByTe_2 } {
   global VerS VFields VDeps VSize tcl_platform

# THIS is the binary array where the data is put

   upvar $Store   bA

# GET the vidf field line and parse it

   gets $fd vLine
   set vOuT [DBvidfLineParse $vLine]

# IF this is an array field then we need to know how many lines of VIDF
#   entries it occupies.  Also if its an array then read the first line
#   of entries.  This initial read puts the array field at the same level
#   as a non-array field. 

   if { [lindex $vOuT 0] == "m" } {
      set v0 [TUdataNoOctal [lindex $vOuT 1]]
      set v1 [TUdataNoOctal [lindex $vOuT 2]]
      set nLines [expr int($v0 / $v1)]
      if { [expr $v0 % $v1] > 0 } { incr nLines }
      gets $fd vLine
      set vOuT [DBvidfLineParse $vLine]
   } else { set nLines 1 }
  
# INITIALIZE the total bytes in this field to 0

   set tB 0

# LOOP over the lines in the field.  All entries are convrted to binary
#   and stored in the binary array holding the field values.

   set J 0
   while { $J < $nLines } {

# ALREADY read the data in and only need new data after the first line 
#   has been processed

      if { $J > 0 } {
         gets $fd vLine
         set vOuT [DBvidfLineParse $vLine]
      }

# THIS is where the different types of entries are processed.

      switch -exact -- [lindex $vOuT 0] {
         t  {  set Line [lindex $vOuT 1]
               append bA [binary format "a80" [format %-79s $Line] ]
               incr tB 80
            }
         T  {  set Entries [llength $vOuT]
               for { set I 1 } { $I < $Entries } { incr I } {
                  set Line [lindex $vOuT $I]
                  append bA [binary format "a21" [format %-20s $Line]]
                  incr tB 21
               }
            }
         l  {  set Entries [llength $vOuT]
               for { set I 1 } { $I < $Entries } { incr I } {
		  set vO [TUdataNoOctal [lindex $vOuT $I] ]
		  if { [string length $vO] == 0 } { set vO 0 }
                  append bA [binary format "$ByTe_4" $vO]
                  incr tB 4
               }
            }
         s  {  set Entries [llength $vOuT]
               for { set I 1 } { $I < $Entries } { incr I } {
		  set vO [TUdataNoOctal [lindex $vOuT $I]]
                  append bA [binary format "$ByTe_2" $vO]
                  incr tB 2
               }
            }
         b  {  set Entries [llength $vOuT]
               for { set I 1 } { $I < $Entries } { incr I } {
		  set vO [TUdataNoOctal [lindex $vOuT $I] ]
                  append bA [binary format "c" $vO]
                  incr tB 1
               }
            }
         n  {   }
      }
      incr J
   }
   return $tB
}
