#  THIS procedure parses a VIDF line from an ASCII file

package provide TclUDFdB 1.0

proc DBvidfParseIDFS { fa cFlg vOuT } {

   upvar $vOuT vO

# READ vidf line - out if done

   if { [gets $fa vLine ] < 0 } { return 0 }

# TRIM the line of all beginning and ending spaces

   set vLine [string trim $vLine]
   if { [string length $vLine] == 0 } { set TyPe BlAnK }

# Parsing rules

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
                                                                                
# Get the line entry

   regexp "$P1" $vLine M TyPe field V com

   if ![info exist TyPe] { set TyPe "" ; set field "" ; set V ""}

# DO a few more manipulations based on the entry type,

   if { [string length $TyPe] > 0 } {
      switch -exact -- $TyPe {
         float   -
         int  { 
            set B [string first "=" $vLine]
            set C [string first "\[" $vLine]
            if { ($C > 0) && ($C < $B) } {
               set field [DBvidfArrayIDFS $fa $field $V Array]
               set V $Array
            }
            if $cFlg { set field crit_$field }
         }
         string {  
            set B [string first "=" $vLine]
            set C [string first "\[" $vLine]
            if { ($C > 0) && ($C < $B) } {
               set field [DBvidfArrayIDFS $fa $field $V Array]
               set V $Array
            } else { set V [string trim $V "\""] }
            if $cFlg { set field crit$field }
         }
         struct {
           if { [string compare CriticalAction $field] == 0 } { 
              set TyPe CriTStR
           }
         }
      }  
   } else {
      set TyPe UnKnOwN
      set B [string first "\}" $vLine]
      if { $B >= 0 } {
         if $cFlg { set TyPe EnDCriTStR } else { set TyPe EnDStrucT }
      } else {
         set B [string first "/*" $vLine]
         if { $B >= 0 } {
            set E [string first "*/" $vLine]
            while { $E < 0 } {
               if { [gets $fa vLine ] < 0 } { return 0 }
               set E [string first "*/" $vLine]
            }
            set TyPe CoMmEnT
         }
      }
   }

   set vO [list $TyPe $field $V]
   return 1
}
