#  THIS procedure takes an IDFS new ascii VIDF file and creates a binary 
#    version of it.

package provide TclUDFdB 1.0

proc DBvidfConvertIDFS { vName } {
   global nVFields nVDeps nVNeed UDFdataOrder

# SET the platform integer format 

   UDFvidfInfoIDFS

  if [string match littleEndian $UDFdataOrder] {
      set ByTe_2 s
      set ByTe_4 i
   } else {
      set ByTe_2 S
      set ByTe_4 I
   }
  
#  ESTABLISH the ascii and binary VIDF file names by adding the appropriate
#    ending to the generic file name passed in.

   set vAscii  ${vName}V
   set vBinary ${vName}I

#  OPEN both files

   if [catch {open $vAscii r} fa ] {
      puts stderr "DBvidfConvertIDFS:  CANNOT OPEN FILE $vAscii"
      return 0
   }

   if [catch {open $vBinary w} fb ] {
      puts stderr "DBvidfConvertIDFS:  CANNOT OPEN FILE $vBinary"
      return 0
   }
   fconfigure $fb -translation binary

#  Determine how many fields there are in the VIDF base fields section

   set nBF [lsearch -exact $nVFields Table,tbl_sca_sz]  

# PARSE the file

   set B ""
   set CrS 0
   while { [DBvidfParseIDFS $fa $CrS vOuT] } {
       switch -exact -- [lindex $vOuT 0] {
          CoMmEnT    {  }
          struct     { set B [lindex $vOuT 1], }
          EnDStrucT  { set B "" }
          UnKnOwN    {  }
          BlAnK      {  }
          vidf       {  }
          CriTStR    { set CrS 1 }
          EnDCriTStR { set CrS 0 }
          default   { lappend ViDf(${B}[lindex $vOuT 1]) [lindex $vOuT 2] }
      } 
   }
   close $fa

   DBvidfCorIDFS ViDf

   set VerS [binary format "a8" "VI2.1" ]
   set Base ""
   set cP 0

   for { set I 0 } { $I < $nBF } { incr I } {
      lappend bOff $cP
      incr cP [DBvidfAddField $I Base $ByTe_4 $ByTe_2 ViDf]
   }

# FLUSH out the Offset list to the size of the VIDF field list
                                                                                
   set fLen [llength $nVFields]
   lappend bOff $cP ; incr I
   for {  } { $I < $fLen } { incr I } { lappend bOff 0 }


# FIND is the number of table definitions in the VIDF and the number of
#   fields in a table definition
                                                                                
   set nT $ViDf(n_tbls)
   set nTFields [lsearch -exact $nVFields Constant,id]

# LOOP through the base VIDF tables
                                                                               
   for { set I 0 } { $I < $nT } { incr I } {
     for { set J $nBF } { $J < $nTFields } { incr J } {
         lappend tOff $cP
         incr cP [DBvidfAddField $J Base $ByTe_4 $ByTe_2 ViDf $I]
      }
   }
   lappend tOff $cP

   set nC $ViDf(n_consts)
   for { set I 0 } { $I < $nC } { incr I } {
     for { set J $nTFields } { $J < $fLen } { incr J } {
         lappend cOff $cP
         incr cP [DBvidfAddField $J Base $ByTe_4 $ByTe_2 ViDf $I]
      }
   }
   lappend cOff $cP

   puts -nonewline $fb $VerS
   set nO [llength $bOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $bOff]
   puts -nonewline $fb [binary format "$ByTe_4" $nT]
   set nO [llength $tOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $tOff]
   puts -nonewline $fb [binary format "$ByTe_4" $nC]
   set nO [llength $cOff]
   set bS [expr $nO * 4]
   puts -nonewline $fb [binary format "$ByTe_4" $bS]
   puts -nonewline $fb [binary format "$ByTe_4$nO" $cOff]
   set fS [string length $Base]
   puts -nonewline $fb [binary format "$ByTe_4" $fS]
   puts -nonewline $fb $Base

   close $fb

   return 1
}
