#  THIS procedure takes an array ASCII entry and converts it into a binary
#    representation

package provide TclUDFdB 1.0

proc DBvidfAddField { I Store ByTe_4 ByTe_2 vIn { S -1 } } {
   global nVFields nVSize nVNeed

# THIS is the binary array where the data is put

   upvar $Store bA
   upvar $vIn   vI

   set tB 0
   set Size [lindex $nVSize $I]
   set Need [lindex $nVNeed $I]
   set FlD [split [lindex $nVFields $I] ","]

   if { $S < 0 } {
      if { [llength $FlD] == 2 } {
          set Entry [DBvidfStruct vI [lindex $FlD 0] [lindex $FlD 1]]
      } elseif ![info exist vI($FlD)] { 
         if !$Need { 
            set Size n 
            set Entry ""
         } else {
            if { $Size == "t" } { set Entry "" } else { set Entry 0 }
         }
      } else { set Entry $vI($FlD) }
   } else {
      set fL [lindex $FlD 0]$S,[lindex $FlD 1]
      if ![info exist vI($fL)] { 
         if !$Need { 
            set Size n 
            set Entry ""
         } else {
            if { $Size == "t" } { set Entry "" } else { set Entry 0 }
         }
      } else { set Entry [lindex $vI($fL) 0] }

      if { [string match *values $fL] && [string match Table* $fL] } {
         if { [lindex $vI(Table$S,tbl_type) 0] == 1 } { set Size T }
      }
   }

   switch -exact -- $Size {
      t  {  set nE [llength $Entry] 
            for { set I 0 } { $I < $nE } { incr I } {
               set Line [string trim [lindex $Entry $I]]
               append bA [binary format "a80" [format %-79s $Line] ]
               incr tB 80
            }
         }
      T  {  set nE [llength $Entry] 
            for { set I 0 } { $I < $nE } { incr I } {
               set Line [string trim [lindex $Entry $I]]
               set Line [string trim Line "\""]
               append bA [binary format "a21" [format %-20s $Line]]
               incr tB 21
            }
         }
      l  {  set nE [llength $Entry] 
            for { set I 0 } { $I < $nE } { incr I } {
               set Line [string trim [lindex $Entry $I]]
	       set vO [TUdataNoOctal $Line] 
	       if { [string length $vO] == 0 } { set vO 0 }
               append bA [binary format "$ByTe_4" $vO]
               incr tB 4
            }
         }
      s  {  set nE [llength $Entry] 
            for { set I 0 } { $I < $nE } { incr I } {
               set Line [string trim [lindex $Entry $I]]
	       set vO [TUdataNoOctal $Line]
	       if { [string length $vO] == 0 } { set vO 0 }
               append bA [binary format "$ByTe_2" $vO]
               incr tB 2
            }
         }
      b  {  set nE [llength $Entry] 
            for { set I 0 } { $I < $nE } { incr I } {
               set Line [string trim [lindex $Entry $I]]
	       set vO [TUdataNoOctal $Line]
	       if { [string length $vO] == 0 } { set vO 0 }
               append bA [binary format "c" $vO]
               incr tB 1
            }
         }
      n  {   }
      
   }
   return $tB
}
