# SWAP the header and data butes according to the user input
#
# INPUTS:
#   Vf:   UDF VIDF file
#   Hf:   UDF Header file
#   Df:   UDF Data file
#   ibF:  Input byte format
#         L - little endian      
#         B - big endian      
#   obF:  Input byte format
#         L - little endian      
#         B - big endian      

package provide TclUDFdB 1.0

proc DBudfSwap { Vf Hf Df iBf oBf } {
   global SInfo VFields VSize VDeps ByTe_2 ByTe_4 UDFdataOrder 

# SET up a dummy UDF Key and Version so that we can use the generic UDF code
#   to access the VIDF parameters

   set Key TmP
   set Ver 0
   set kV TmP,0

# OPEN the VIDF file 

   if [catch {open $Vf r} SInfo($kV,VFD)] {
      puts stderr "DBdataSwap: Can't Open $Vf"
      return -1
   }
   fconfigure $SInfo($kV,VFD) -translation binary

# LOAD the VIDF definition parameters if they are not already

   if ![info exists VFields] { UDFvidfInfo }

# LOAD the native interger representations

   if [string match littleEndian $UDFdataOrder] {
      set ByTe_2 s
      set ByTe_4 i
   } else {
      set ByTe_2 S
      set ByTe_4 I
   }

   set vI(First) 1
   set vI(kV) $kV

# INITIALIZE the VIDF information.  IN this case we are 

   UDFvidfInit $kV

# LOAD all of the VIDF parameters that will be needed to perform the
#    the swap

   ReadVIDF $Key $Ver MAXNSS 0 0 0 vI(MaxNss)
   ReadVIDF $Key $Ver SMPID 0 0 0 vI(SmpId)
   ReadVIDF $Key $Ver CALSETS 0 0 0 vI(CalSets)
   ReadVIDF $Key $Ver DAMETHOD 0 0 0 vI(DaMethod)
   ReadVIDF $Key $Ver SWPLEN 0 0 0 vI(SwpLen)

   if { $vI(CalSets) != 0 } {
      ReadVIDF $Key $Ver CALWLEN 0 0 -1 CalWLen 1
      ReadVIDF $Key $Ver CALTARGET 0 0 -1 vI(CalTarget)
      ReadVIDF $Key $Ver CALUSE 0 0 -1 vI(CalUse)
   }

   ReadVIDF $Key $Ver SEN 0 0 0 vI(NSen)
   ReadVIDF $Key $Ver DATALEN 0 0 0 vI(DataLen)
   ReadVIDF $Key $Ver TDWLEN 0 0 -1 TdwLen 1

   set BitLenB 0
   for { set I 0 } { $I < $vI(NSen) } { incr I } {
      if { $TdwLen($I) > $BitLenB } {
         set BitLenB $TdwLen($I) 
      }
   }

   if { $BitLenB <= 8 } {
      set WdLenB 1
   } elseif { $BitLenB <= 16 } { set WdLenB 2 } else { set WdLenB 4 }

   set BitLenA 0
   set BitLenC 0
   set BitLenD 0
   set WdLenA 0
   set WdLenC 0
   set WdLenD 0
   set nA 0
   set nC 0
   set nD 0
   if { $vI(CalSets) > 0 } {
      for { set I 0 } { $I < $vI(CalSets) } { incr I } {
         set cTar [lindex $vI(CalTarget) $I]
         set cUse [lindex $vI(CalUse) $I]
         if { ($cUse == 0) || ($cTar == 3) } {
            set Num 1
         } else { set Num [expr int($vI(SwpLen) / $cUse)] }
      
         if { $CalWLen($I) < 0 } { set CalWLen($I) [expr -$CalWLen($I)] }
         if { [lindex $vI(CalTarget) $I] == 3 } {
            if { $CalWLen($I) > $BitLenA  } { set BitLenA $CalWLen($I) }
	    incr nA $Num
         } elseif { [lindex $vI(CalTarget) $I] == 2 } {
            if { $CalWLen($I) > $BitLenC  } { set BitLenC $CalWLen($I) }
	    incr nC $Num
         } else {
            if { $CalWLen($I) > $BitLenD  } { set BitLenD $CalWLen($I) }
	    incr nD $Num
         }
      }
   }

   if { $BitLenA <= 8 } {
      set WdLenA 1
   } elseif { $BitLenA <= 16 } { set WdLenA 2 } else { set WdLenA 4 }
   if { $BitLenC <= 8 } {
      set WdLenC 1
   } elseif { $BitLenC <= 16 } { set WdLenC 2 } else { set WdLenC 4 }
   if { $BitLenD <= 8 } {
      set WdLenD 1
   } elseif { $BitLenD <= 16 } { set WdLenD 2 } else { set WdLenD 4 }

   set vI(BitLen) [list $BitLenA $BitLenB $BitLenC $BitLenD]
   set vI(WdLen)  [list $WdLenA $WdLenB $WdLenC $WdLenD]
   set vI(nAncS)  [list $nA 0 $nC $nD]

   DBswapHeader $Hf vI $iBf $oBf
   DBswapData   $Hf $Df vI $iBf $oBf

   close $SInfo($kV,VFD)
   UDFunsetSInfo $kV
}
