package provide TclUDFdB 1.0
                                                                                
proc DBtimesVIDF { vD vName } {
   global VFields VSize VDeps SInfo ByTe_4

# CHECK to see if the VIDF information arrays have been loaded.  If not
#   load them now

    if ![info exists ByTe_4] { UDFInits }

# INITIALIZE the return list

   set rL ""

#  Form the fill path name to the file

   if { [string index $vName end] != "I" } { append vName I }
   set vName [file join $vD $vName]

#   NOTE: WE USE A DUMMY KEY.VER OF -1,0.  WE ARE NOT GOING THROUGH ALL OF 
#   THE FORMAL UDF LINEAGE AND SO CAN'T BUILD A REAL KEY 

   set kV -1,0

# OPEN the vidf file.

   if [catch {open $vName r} SInfo($kV,VFD)] {
      puts stderr "CANNOT OPEN $vName"
      return -1
   }

# READ in the vidf information 

   UDFvidfInit $kV

# OK - read in start times and produce the start hr min sec.  Format them 
#   well so they are ready to output

   UDFvidfFld $kV DSYEAR 0 0 0 sYr 0
   UDFvidfFld $kV DSDAY 0 0 0 sDy 0
   UDFvidfFld $kV DSMSEC 0 0 0 sMs 0
  
   set sHr [expr int($sMs / 3600000)]
   set sMn [expr int(($sMs % 3600000) / 60000)]
   set sSc [expr int($sMs % 60000) / 1000]
   set sUs [expr ($sMs % 1000) * 1000]

# NOW - read in end times.  Format them well so they are ready to output

   UDFvidfFld $kV DEYEAR 0 0 0 eYr 0
   UDFvidfFld $kV DEDAY 0 0 0 eDy 0
   UDFvidfFld $kV DEMSEC 0 0 0 eMs 0

   set eHr [expr int($eMs / 3600000)]
   set eMn [expr int(($eMs % 3600000) / 60000)]
   set eSc [expr int($eMs % 60000) / 1000]
   set eUs [expr ($eMs % 1000) * 1000]

# PACKAGE them up

  set rL [list $sYr $sDy $sHr $sMn $sSc $sUs $sMs \
                $eYr $eDy $eHr $eMn $eSc $eUs $eMs ]

  close $SInfo($kV,VFD)
  UDFunsetSInfo -1,0
  return $rL
}

