# THIS package sorts through a set of database entries as returned from 
#    DBdbfOpen and returns the beginning and ending positions in that 
#    list which contain the entered start and stop times. 

package provide TclUDFdB 1.0

proc DBtimeEntry { dBInfo Yb Db Msb Ye De Mse } {
   global env 
   
   upvar $dBInfo dB

# USE a binary search to locate the starting time in the list of database
#    entries returned.  

   set LoW 0
   set MiD -1 
   set HigH [expr [llength $dB(KeyList)] - 1]
   set MaX [llength $dB(KeyList)]
   while { $LoW <= $HigH } {
      set MiD [expr ($LoW + $HigH) / 2]
      set dBRec [lindex $dB(KeyList) $MiD]
      binary scan [lindex $dBRec 0] a8a4a3a8a4a3a8 V BYr BDy BMs EYr EDy EMs
      set Condition [TUtimeCmp 0 $Yb $Db $Msb $EYr $EDy $EMs]
      if { $Condition < 0 } {
         set HigH [expr $MiD - 1 ]
      } elseif { $Condition > 0 } {
         set LoW [expr $MiD + 1 ]
      } else { break }
   }

# IF the beginning time is beyond the end time of the last list entry
#    then there are no entries in the database in the requested time 
#    range.

   if { $LoW == $MaX } { return "" }

# THIS is the starting record within the database

   set StarT $MiD

# USE a binary search again to locate the ending time in the list of database
#    entries returned.  

   set LoW $MiD
   set MiD -1 
   set HigH [expr [llength $dB(KeyList)] - 1]
   set MiN $LoW
   while { $LoW <= $HigH } {
      set MiD [expr ($LoW + $HigH) / 2]
      set dBRec [lindex $dB(KeyList) $MiD]
      binary scan [lindex $dBRec 0] a8a4a3a8a4a3a8 V BYr BDy BMs EYr EDy EMs
      set Condition [TUtimeCmp 0 $Ye $De $Mse $BYr $BDy $BMs]
      if { $Condition < 0 } {
         set HigH [expr $MiD - 1 ]
      } elseif { $Condition > 0 } {
         set LoW [expr $MiD + 1 ]
      } else { break }
   }

# IF the ending time is less than the beginning time of the starting record
#    then there is no database entries in the requested time range.

   if { $HigH < $MiN } { return "" }

# THIS is the ending record in the database.

   set EnD $MiD

#  FINAL tests.  The file times can be and most likely are discontinuous.
#    If the beginning or ending time falls between two files you are
#    going to get the pointers to files which are either one earlier or
#    one later than wanted.

   set dBRec [lindex $dB(KeyList) $EnD]
   binary scan [lindex $dBRec 0] a8a4a3a8a4a3a8 V BYr BDy BMs EYr EDy EMs
   set Condition [TUtimeCmp 0 $Ye $De $Mse $BYr $BDy $BMs]
   if { $Condition < 0 } { incr EnD -1 }

   set dBRec [lindex $dB(KeyList) $StarT]
   binary scan [lindex $dBRec 0] a8a4a3a8a4a3a8 V BYr BDy BMs EYr EDy EMs
   set Condition [TUtimeCmp 0 $Yb $Db $Msb $EYr $EDy $EMs]
   if { $Condition > 0 } { incr StarT  }

   if { $StarT == $EnD } {
      return $StarT
   } else { return [list $StarT $EnD] }
}
