# THIS procedure compares two time ranges and determines if there is any
#   overlap.  It returns its findings as
#
#   0 :  No overlap
#   1 :  Overlap
#   2 :  Exact Match

package provide TclUDFdB 1.0

proc DBtimeCmp { tA tB t1 t2 } {

# DETERMINE if tA or tB fall in the range set by t1 and t2.  Do this by
#   sorting the time strings

   set tList [lsort -ascii -increasing [list $tA $t1 $tB]]
   set pB [lsearch $tList $t1]
   set tList [lsort -ascii -increasing [list $tA $t2 $tB]]
   set pE [lsearch $tList $t2]

# WHEN the position of the checked time is the first or last in the sorted
#   list then we need to see if it matches the time being checked against.

   if { ($pB == 0) && [string match $tA $t1] } { set pB 1 }
   if { ($pE == 0) && [string match $tA $t2] } { set pE 1 }
   if { ($pB == 2) && [string match $tB $t1] } { set pB 1 }
   if { ($pE == 2) && [string match $tB $t2] } { set pE 1 }

# IF the beginning time being checked is greater than the end time of the
#   interval or the end time being checked is less than the starting time
#   of the interval there is no overlap.  Otherwise there is.

   if { ($pB == 2) || ($pE == 0) } {
      set Status 0 
   } elseif { ($pB == 1) && ($pE == 1) } {
      set Status 2
   } else { set Status 1 }

   return $Status
}
