# SWAP the header bytes from big endian to little endian or vice versa.
#
# INPUTS:
#   HdR:   UDF Header file
#   vInfo: VIDF info needed in the swap process
#   ibF:   Input byte format
#          L - little endian      
#          B - big endian      
#   obF:   Input byte format
#          L - little endian      
#          B - big endian      

package provide TclUDFdB 1.0

proc DBswapHeader2 { HdR vInfo iBf oBf } {
   global env 

   upvar $vInfo vI

# SET the input and output write formats

   if { $iBf == "L" } {
      set iB4 i ; set iB2 s
   } else { set iB4 I ; set iB2 S }

   if { $oBf == "L" } {
      set oB4 i ; set oB2 s
   } else { set oB4 I ; set oB2 S }

# OPEN the header file as read/write

   if [catch {open $HdR r} fd] {
      puts stderr "DBswapHeader: Can't Open $HdR"
      return -1
   }
   if [catch {open ._TmP_ w} fo] {
      puts stderr "DBswapHeader: Can't Open Temporary File"
      return -1
   }
   fconfigure $fd -translation binary
   fconfigure $fo -translation binary

# GET the file size.  Need this to know when the file has been processed.

   set fS [file size $HdR]

# LOOP over the the file header record by header record

   while { [tell $fd] < $fS } {

# CONVERT the file size

      binary scan [read $fd 2] $iB2 hSize
      puts -nonewline $fo [binary format $oB2 $hSize]

# CONVERT the YEAR/DAY 

      binary scan [read $fd 4] ${iB2}2 TmP
      puts -nonewline $fo [binary format ${oB2}2 $TmP]
      binary scan [read $fd 2] c2 TmP
      puts -nonewline $fo [binary format c2 $TmP]

# CONVERT the ACCUM/LAT/SCAN/SENSOR SET times

      binary scan [read $fd 16] ${iB4}4 TmP
      puts -nonewline $fo [binary format ${oB4}4 $TmP]

# CONVERT the NUMBER of SENSORS and SAMPLES fields

      binary scan [read $fd 4] ${iB2}${iB2} nSen nSmp
      puts -nonewline $fo [binary format ${oB2}${oB2} $nSen $nSmp]
      set rP 28

# IF UDF has matrix data convert the three matrix infomation fields

      if { $vI(SmpId) == 3 } {
         binary scan [read $fd 6] ${iB2}3 TmP
         puts -nonewline $fo [binary format ${oB2}3 $TmP]
	 incr rP 6
      }

# IF UDF has scalar data there is only one scan index value

      if { $vI(SmpId) == 2 } { set nSmp 1 }

# CONVERT the SCAN and SENSOR index arrays

      set N [expr $nSmp  + $nSen]
      set B [expr 2 * $N]
      binary scan [read $fd $B] ${iB2}$N TmP
      puts -nonewline $fo [binary format ${oB2}$N $TmP]
      incr rP $B

# REST of the data is byte data and doesn't get converted. Just skip it.

      set B [expr $hSize  - $rP]
      binary scan [read $fd $B] c$B TmP
      puts -nonewline $fo [binary format c$B $TmP]
   }

   close $fd
   close $fo

   file delete -force $HdR
   file rename -force ._TmP_ $HdR
}
