# THIS is a test designed to check if this file may need to have the sensor
#   and or ancillary storage size changed.  This may need to be done for 
#   IDFS files which keep the sensor and ancillary data on a common bytes
#   size.

package provide TclUDFdB 1.0

proc DBsasizeChk { nSS vInfo } {
   global env SInfo 

   upvar $vInfo vI

# IF this is an IDFS file then the data and the sensor ancillary word length
#   must be identical.  Since we don't know if this is an IDFS file we need
#   to guess if we need to set the two word lengths the same)

# LETS get rid of the "can't tell" case.  This happens if the nSS in the
#   data record is < 0.

    if { $nSS < 0 } { return }

# GET all the word lengths stripped out and the number of sensor data

   set pW [lindex $vI(WdLen) 0]
   set dW [lindex $vI(WdLen) 1]
   set gW [lindex $vI(WdLen) 2]
   set aW [lindex $vI(WdLen) 3]
   set pA [lindex $vI(nAncS) 0]
   set gA [lindex $vI(nAncS) 2]
   set aA [lindex $vI(nAncS) 3]

# NOW see what we can do

# 1.  If this has a version of 2.1 or less it might be.

   if { $SInfo($vI(kV),VER) <= 2.1 } {

# 2.  If there is general or preface ancillary data then this is not an IDFS
#     file or if the data and sensor ancillary word lengths are the same it
#     doesn't matter since everything is OK as it stands

      if { ($pA == 0) && ($gA == 0) && ($aA != 0) && ($dW != $aW) } {

# 3.  Get the number of bytes which is assigned to a sensor set.

         set dS [expr $vI(DataLen) - 4 * (4 + $vI(MaxNss))]
         set dS [expr $dS / $vI(MaxNss)]

# 4. This is the number bytes left over if we use things as is

         set tB [expr $vI(NSen) * ($vI(SwpLen) * $dW + $aA * $aW)]
         set dDa [expr $dS - $tB]

# 5. Same but setting word lengths to max

         if { $dW > $aW } { set wL $dW } else { set wL $aW }

         set tB [expr $vI(NSen) * ($vI(SwpLen) * $wL + $aA * $wL)]
         set dDb [expr $dS - $tB]

	 if { ($dDb >= 0) && ($dDb < $dDa) } {
            set vI(WdLen) [list $pW $wL $gW $wL]
	 }
      }
   }

   set vI(First) 0
}
