# THIS package sorts through a database and removes all of the entries
#   which are duplicate of the entries to be added to it.  It also 
#   removes the files the entries point to.  
#
# NOTE:  UDFPaths should be current for the data being removed!

package provide TclUDFdB 1.0

proc DBremoveDups { dType In fName } {
   global env UDFPaths 

# THESE are the DBF and NDX databases

   set dbDBF [file join $UDFPaths(1) $In.$dType.DBF]
   set dbNDX [file join $UDFPaths(1) $In.$dType.NDX]

# IF either doesn't exist then leave

   if { ![file exists $dbDBF]|| ![file exists $dbNDX] } { return }

   set fN [llength $fName]
   set dL ""
   set nL ""
   for { set I 0 } { $I < $fN } { incr I } {
      set bName [DBfileBname [lindex $fName $I]]
      set PoS [DBfileDup $dbDBF dB $bName]

      set pLen [llength $PoS]
      if { $pLen > 0 } {
         if [string match $dType HD] { 
            set FileA [file join $UDFPaths(2) ${bName}D]
            set FileB [file join $UDFPaths(2) ${bName}H]
         } else {
            set Cmps [file split $UDFPaths(1)]
            set nC [expr [llength $Cmps] - 1]
            set vDir ""
            for { set J 0 } { $J < $nC } { incr J } {
               set vDir [file join $vDir [lindex $Cmps $J]]
            }
            set FileA [file join $UDFPaths(2) ${bName}I]
            set FileB [file join $vDir ${bName}V]
         }
         if [file exists $FileA] { file delete -force $FileA }
         if [file exists $FileB] { file delete -force $FileB }

         for { set J 0 } { $J < $pLen } { incr J } {
           set Loc [lindex $PoS $J]
           lappend dL [lindex $Loc 0]
           lappend nL [lindex $dB(KeyList) [lindex $Loc 1] ]
         }
      }
   }
   DBdbfDelete $dbDBF $dL
   DBndxDelete $dbNDX $nL
}
