# THIS procedure builds an NDX file from a DBF file.  Useful if somehow
#    either the NDX file associated with a DBF file has either got corrupted
#    or inadvertly deleted.

# Inputs: 
#   dbF  - The database name
#
#  Returns:   1   OK
#            -2   Could not open the entry file


package provide TclUDFdB 1.0

proc DBndxFromdbf { dbF } {
   global env

# QUICK check to make that the database file exists.

   if ![file exists $dbF] { return -1 }

# OPEN the database file 

   DBdbfOpen $dbF dB ALLVIRTUALS r
   fconfigure $dB(fd) -translation binary

# ESTABLISH the ndx file name

   set dbN [file rootname $dbF].NDX

# IF it exists then remove it

   if [file exists $dbN] { file delete -force $dbN }

# CREATE the NDX file, then open it 

   DBndxCreate $dbN
   DBndxOpen $dbN nX "" a+

# GET to where the NDX records will be laid down

   seek $nX(fd) 96 start

# NOW loop over the DBF entries and put them into the NDX file.  The
#   DBF entries should already be in ascending order. 

   set nE [llength $dB(KeyList)]
   set f1Len [expr $nX(KeyLen) + $nX(Pad)]
   for { set I 0 } { $I < $nE } { incr I } { 
      set Entry [lindex $dB(KeyList) $I]
      set ndxKey [string range [lindex $Entry 0] 0 22]
      set ndxPos [expr [lindex $Entry 1]  + 1]
      set Rec [binary format a${f1Len}${nX(bFmt)} $ndxKey $ndxPos]
      puts -nonewline $nX(fd) $Rec
   }
      

# REFORM the NDX file header

   seek $nX(fd) 0 start
   puts -nonewline $nX(fd) [string range $nX(Head) 0 3]
   seek $nX(fd) 4 start
   set tRecs $nX(NumRecs)
   if { $nE > $tRecs } { set tRecs $nE }
   puts -nonewline $nX(fd) [binary format $nX(bFmt)$nX(bFmt) $nE $tRecs ]
   seek $nX(fd) 12 start
   puts -nonewline $nX(fd) [string range $nX(Head) 12 end]
   
   close $nX(fd)
   close $dB(fd)

   return 1
}
