#  This procedure deletes one or more extries in the NDX database file.
#   
#  INPUTS:
#     dbN    - the NDX file name with full path attached
#     rmList - the remove list.  This is a list the DBF keys removed.

package provide TclUDFdB 1.0

proc DBndxDelete { dbN rmList } {
  
# OPEN the NDX file if it exists.  If not just leave the procedure.  Always
#   possible that this is an archive database which has no NDX file.

   if ![file exists $dbN] { return }
   DBndxOpen $dbN nX "" r
   fconfigure $nX(fd) -translation binary

# NUMBER of entries being removed

   set rLen [llength $rmList]

# BUILD a list of the NDX positions to remove and a list of the positions
#   within the DBF file removed.

   set dbfPos ""
   set ndxPos ""
   for { set I 0 } { $I < $rLen } { incr I } {
      set rKey [lindex [lindex $rmList $I] 0]
      set ndxKey [string range $rKey 0 22]
      set Index [lsearch -exact $nX(Key) $ndxKey] 
      if { $Index >= 0 } {
         lappend ndxPos $Index
         lappend dbfPos [lindex $nX(Pos) $Index]
      }
   }
   lappend dbfPos 10000000

# GET the actual number of records being removed.  If this is 0 then there
#    is nothing to do - there is also probably a problem with the NDX file.

   set rLen [llength $ndxPos]
   if { $rLen == 0 } { close $nX(fd) ; return 0 }

# IF there are or will be no records left in the NDX file after the removal
#   then simply delete the NDX file

   set fRecs [expr $nX(NumRecs) - $nX(NextRec) + $rLen ] 
   if { $fRecs <= 0 } {
      close $nX(fd)
      file delete -force $dbN
      return -1
   }

# SORT the dbf record positions removed smallest to largest and then get
#    them into the format used by NDX (pos + 1)

   set dbfPos [lsort -integer -increasing $dbfPos]
   set ndxPos [lsort -integer -increasing $ndxPos]
   set dLen [llength $dbfPos]

# OPEN the temporary NDX file

   if [catch {open ._TmPNx w} fo] {
      puts stderr "DBndxDELETE:  CANNOT OPEN TEMPORARY NDX FILE"
      return -2
   }
 
# WRITE out the file header 

   set fRec [expr $nX(NextRec) - $rLen]
   seek $fo 0 start
   puts -nonewline $fo [string range $nX(Head) 0 3]
   puts -nonewline $fo [binary format ${nX(bFmt)}${nX(bFmt)} $fRec $fRec]
   puts -nonewline $fo [string range $nX(Head) 12 end]
      
# ADD the last NDX position to the remove list.  This is just for looping
#    purposes.  The position will not be removed.

   lappend ndxPos $nX(NextRec)
   incr rLen

# ALL positions below this are unchanged

   set LoW [lindex $dbfPos 0]

# THIS is the byte length of the first field plus the pad

   set f1Len [expr $nX(KeyLen) + $nX(Pad)]

# LOOP over the NDX records removing those which have been deleted

   set Beg 0
   seek $nX(fd) 96 start 
   for { set I 0 } { $I < $rLen } { incr I } {
      set End [lindex $ndxPos $I]
      for { set J $Beg } { $J < $End } { incr J } {
         set Rec [read $nX(fd) $nX(RecLen)]
         binary scan $Rec a${f1Len}$nX(bFmt) Key Pos
         if { $Pos > $LoW } {
            set A [lindex $dbfPos 0]
            for { set K 1 } { $K < $dLen } { incr K  } {
               set B [lindex $dbfPos $K]
               if { ($Pos > $A) && ($Pos < $B) } {
                  set Pos [expr $Pos - $K]
                  break
               }
               set A $B
            }
         }
         set nRec [binary format a${f1Len}$nX(bFmt) $Key $Pos]
         puts -nonewline $fo $nRec
      }
      
# THIS is the deleted record.

      set Rec [read $nX(fd) $nX(RecLen)]
      set Beg [expr $End + 1]
   }

   close $nX(fd)
   close $fo
   file rename -force ._TmPNx $dbN
}
