
#  This procedure creates an NDX database file and fills the header information 
#
#  Returns:   1   Database created and initialized
#            -1   Could not create Database file
#            -2   Database exists already

package provide TclUDFdB 1.0

proc DBndxCreate { NDXname } {
   global env tcl_platform UDFdataOrder

# GET the platform integer format
                                                                                
  if [string match littleEndian $UDFdataOrder] {
      set ByTe_4 i
   } else { set ByTe_4 I }

# IF the NDX database file already exists don't overwrite it!  Make some
#   other routine or someone else remove it first.

   if [file exists $NDXname] { return -2 }

# CREATE the NDX database and make sure its binary

   if [catch {open $NDXname w} NDXfd ] { return -1 }
   fconfigure $NDXfd -translation binary

# NUMBER of blank records to start the database with

   set nRec 10

# THESE are the fields created within the database.  There are only 4, the
#   last is a blank (unused) key

   set F(0)  [list V_INST C 8]
   set F(1)  [list B_YR N 4]
   set F(2)  [list B_DAY N 3]
   set F(3)  [list B_MSEC N 8]
   set F(4)  [list "" "" 0]

# FIND the value needed to pad the key length to an integral 4 byte value

   set kLen 0
   for { set I 0 } { $I < 4 } { incr I } {
      set kLen [expr $kLen + [lindex $F($I) 2] ]
   }
   set PaD [expr (4 - ($kLen % 4)) % 4]

# This is the record length

   set rLen [expr $kLen + $PaD + 4]

# OK lets start writing out the header information.  The first three bytes
#    are an iD (I think), the first free record, the total number of recrods,
#    and the number of fields.

   set OuT [binary format ${ByTe_4}4 [list 319383296 0 $nRec 4]]
   puts -nonewline $NDXfd $OuT 

# WRITE out the field information

   for { set I 0 } { $I < 5 } { incr I } {
      seek $NDXfd [expr $I * 16 + 16] start
      set Fld  [lindex $F($I) 0]
      set Type [lindex $F($I) 1]
      set Len  [lindex $F($I) 2]
      set Extra 0
      set OuT [binary format a10ac$ByTe_4 $Fld $Type $Len $Extra] 
      puts -nonewline $NDXfd $OuT
   }

# WRITE OUT the blank records

   seek $NDXfd 96 start
   set ReC ""
   set BlankRec [binary format a$rLen $ReC] 
   for { set I 0 } { $I < $nRec } { incr I } {
      puts -nonewline $NDXfd $BlankRec
   }

   close $NDXfd 
}

