# THIS procedure appends entries to an NDX database file.  Entries need
#   to be entered into the file in ascending order.
#   
# Inputs: 
#   dbN  - The database name
#   dbE  - A file name of individual entries
#
#  Returns:   1   Entries appended 
#            -1   Could not open the Database file
#            -2   Could not open the entry file


package provide TclUDFdB 1.0

proc DBndxAppend { dbN dbE dbfPos } {
   global env

# QUICK check to make sure that both the database and entry file exist.

   if ![file exists $dbN] { DBndxCreate $dbN }
   if ![file exists $dbE] { return -2 }

# OPEN the database file 

   DBndxOpen $dbN nX "" a+
   fconfigure $nX(fd) -translation binary

# GET to the start of the key data

   seek $nX(fd) 96 start

# NUMBER of bytes of data in the NDX file

   set nBytes [expr $nX(RecLen) * $nX(NumRecs)] 

# READ the data putting the ndx records into a big list

   set Keys [read $nX(fd) $nBytes] 

   set f1Len [expr $nX(KeyLen) + $nX(Pad)]
   set kList ""
   for { set I 0 } { $I < $nX(NumRecs) } { incr I } {
      set bOff [expr $I * $nX(RecLen)]
      binary scan $Keys @${bOff}a${f1Len}$nX(bFmt) KeY PoS
      if { $PoS == 0 } { break }
      lappend kList [list $KeY $PoS]
   } 

# GET rid of the binary data array.  Don't need it anymore

   unset Keys

# OPEN the entry file and add the appended data to the key list

   if [catch {open $dbE r} fd ] { return -2 } 

   incr dbfPos
   while { [gets $fd LiNe] >= 0 } {
      set Fields [split $LiNe "|"]
      set V    [lindex $Fields 0]
      set By   [format "%4s" [lindex $Fields 1] ]
      set Bd   [format "%3s" [lindex $Fields 2] ]
      set Bms  [format "%8s" [lindex $Fields 3] ]
      set KeY [format %-8s%4s%3s%8s $V $By $Bd $Bms]
      lappend kList [list $KeY $dbfPos]
      incr dbfPos
   }

# SORT the key list in ascending order based in the key entry

   set kList [lsort -ascii -increasing -index 0 $kList]

# REENTER the ordered Keys into the NDX file 

   seek $nX(fd) 96 start
   set nRecs [llength $kList]
   for { set I 0 } { $I < $nRecs } { incr I } {
      set KeY [lindex [lindex $kList $I] 0]
      set PoS [lindex [lindex $kList $I] 1]
      set OuT [binary format a${f1Len}${nX(bFmt)} $KeY $PoS]
      puts -nonewline $nX(fd) $OuT
   }

   seek $nX(fd) 0 start
   puts -nonewline $nX(fd) [string range $nX(Head) 0 3]
   seek $nX(fd) 4 start
   set tRecs $nX(NumRecs)
   if { $nRecs > $tRecs } { set tRecs $nRecs }
   puts -nonewline $nX(fd) [binary format $nX(bFmt)$nX(bFmt) $nRecs $tRecs ]
   seek $nX(fd) 12 start
   puts -nonewline $nX(fd) [string range $nX(Head) 12 end]
   
   close $nX(fd)
   close $fd

   return 1
}
