# GENERATE one ascii database input file
#
# INPUTS:
#   iD    -  The is he type of data being processed
#                I - VIDF files 
#                D - Header/Data files 
#   vD    -  The directory to find the binary VIDF files in
#   fD    -  The directory to find the HD files
#   fN    -  List containing files to process
#   aCode -  The archive iD to use
#   cCode -  Archive Compression Code 
#               0 - uncompressed
#               1 - gzipped

package provide TclUDFdB 1.0

proc DBgenEntries { iD vD fD dbE fN {aCode "xxx"} {cCode " "} {OpenAs w} } {
   global env SySCmDs UDFPaths

# GET the current time as year month day 

   set dt [clock format [clock seconds] -format %Y%m%d]

# OPEN or create the database entry file.  Make sure there are no stale
#    files around if opening as write.  Should need to make the check in
#    any case but better safe than sorry

   if { $OpenAs == "w" } {
     if { [file exists $dbE] == 1} { file delete -force $dbE }
   }
   if [catch {open $dbE $OpenAs} fd] {
      puts stderr "Can't Open $dbE"
      return -1
   }

# GET the number of files to process

   set fLen [llength $fN]

# Process all of the files in fN according to the type of data.

   switch -exact -- $iD {
      V { 
	 for { set I 0 } { $I < $fLen } { incr I } {
            set vName [DBfileBname [lindex $fN $I]]
            set Rm [expr [string length $vName] - 12]
            set ViR [string range $vName 0 $Rm]
            set Tm [DBtimesAVIDF $vD $vName]
            set V1 [lindex $Tm 0]
            set V2 [lindex $Tm 1]
            set V3 [lindex $Tm 6]
            set V4 [lindex $Tm 7]
            set V5 [lindex $Tm 8]
            set V6 [lindex $Tm 13]
            puts -nonewline $fd "$ViR|$V1|$V2|$V3|$V4|$V5|$V6|"
            puts $fd "-1| |$cCode|  |$aCode|$dt"
	 }
      }
      I { 
	 for { set I 0 } { $I < $fLen } { incr I } {
            set vName [DBfileBname [lindex $fN $I]]
            set Rm [expr [string length $vName] - 12]
            set ViR [string range $vName 0 $Rm]
            set Tm [DBtimesVIDF $vD $vName]
            set V1 [lindex $Tm 0]
            set V2 [lindex $Tm 1]
            set V3 [lindex $Tm 6]
            set V4 [lindex $Tm 7]
            set V5 [lindex $Tm 8]
            set V6 [lindex $Tm 13]
            puts -nonewline $fd "$ViR|$V1|$V2|$V3|$V4|$V5|$V6|"
            puts $fd "-1| |$cCode|  |$aCode|$dt"
	 }
      }
      D { 

# GENERATE listing of all files in the VIDF directory 

         set vFiles [exec $SySCmDs(ls) $vD]
	 set vLen [llength $vFiles]

# LOOP over all files

	 for { set I 0 } { $I < $fLen } { incr I } {

# File name to process

            set fName [DBfileBname [lindex $fN $I]]
            set Rm [expr [string length $fName] - 12]
            set ViR [string range $fName 0 $Rm]

# GET a VIDF file to associate with this file

	    set OK 0
	    for { set J 0 } { $J < $vLen } { incr J } {
	      set vN [lindex $vFiles $J]
	      if { [string index $vN end] == "I" } {
	         set V [string range $vN 0 [expr [string length $vN] - 13]]
		 if [string match $V $ViR] { set OK 1 ; break }
	      }
	    }

            if !$OK { close $fd ; return -2 }
	    set vName [file join $vD $vN]
	    set dName [file join $fD ${fName}D]
	    set hName [file join $fD ${fName}H]

# PUT the data into native integer format

            DBautoSwap $vName $hName $dName

# CREATE the database entry 

            set Tm [DBtimesHD $fD $fName $vD $vN]
            set V1 [lindex $Tm 0]
            set V2 [lindex $Tm 1]
            set V3 [lindex $Tm 6]
            set V4 [lindex $Tm 7]
            set V5 [lindex $Tm 8]
            set V6 [lindex $Tm 13]
            puts -nonewline $fd "$ViR|$V1|$V2|$V3|$V4|$V5|$V6|"
            puts $fd "-1| |$cCode|  |$aCode|$dt"

	 }
      }
   }

   close $fd
}
