# THIS package sorts through a database and returns all positions in that 
#   database that point to files which will have duplicate file names 
#   to the input one

package provide TclUDFdB 1.0

proc DBfileDup { dbF dBInfo fName } {
   global env 

   upvar $dBInfo dB
   
# BREAK apart the file name into its components and change time to Msec

   set fName [DBfileBname $fName]
   set sLen [expr [string length $fName] - 11]
   scan $fName "%${sLen}s%4d%3d%2d%2d" V bYr bDy bHr bMn
   set bMs [expr 3600000 * $bHr + 60000 * $bMn]

# FORM an end time 60 seconds beyond the beginning time

   set eYr $bYr
   set eDy $bDy
   set eMs [expr $bMs + 60000]
   if { $eMs >= 86400000} {
      set eMs [expr $eMs - 86400000]
      incr eDy
      set TotDy [TUyearLeap $eYr] 
      if { $eDy == $TotDy } {
         set eDy 1
         incr eYr
      }
   }

# GET all of the database entries for this virutal

   set rList ""
   if { [DBdbfOpen $dbF dB $V] > 0 } {
      set kList [DBtimeEntry dB $bYr $bDy $bMs $eYr $eDy $eMs]

# IF there are some database entries then any entries which have a time
#   which is equal to or greater than the beginning time and less than
#   the ending time will be the result of a duplicate file name.

      set rLen [llength $kList]
      if { $rLen > 0 } {
         for { set I 0 } { $I < $rLen } { incr I } {
            set kPos [lindex $kList $I]
            set dBKey [lindex [lindex $dB(KeyList) $kPos] 0] 
            set dBPos [lindex [lindex $dB(KeyList) $kPos] 1] 
            binary scan $dBKey "a8a4a3a8" Virtual fYr fDay fMsec
            set fDy [string trim $fDay]
            set fMs [string trim $fMsec]
            set C1 [TUtimeCmp 0 $fYr $fDy $fMs $bYr $bDy $bMs]
            set C2 [TUtimeCmp 0 $fYr $fDy $fMs $eYr $eDy $eMs]
            if { ($C1 >= 0) && ($C2 < 0) } { lappend rList "$dBPos $kPos" }
         }
      }
      close $dB(fd)
   }

   return $rList
}
