# RETURNS (list or lists):
#            
#  ReT List Element Fmt: 
#              0   Table Number 
#              1   Input Buffer Number 
#              2   Output Buffer Number 
#              3   Extended Operator 
#              4   Base Operator 
#              5   Table Operator

package provide TclUDF 1.0

proc UTILunits { K UnitN SenN { PSrc Sen } } {
   global SInfo Pidf0

   set Key [lindex [split $K ","] 0]
   ReadPIDF $Key
   set Tbls [lindex $Pidf0(UnitTbls) $UnitN]
   set Ops [lindex $Pidf0(UnitOps) $UnitN]
   set SubS -1
   switch -exact -- $PSrc {
     Sen {
        set sN [lindex $Pidf0(SenVidfN) $SenN]
        if [string match V [lindex $Pidf0(SenSrc) $SenN] ] {
           set Src SENSOR
           set vSen $sN
        } else { set Src ANCILLARY ; set vSen 0 } 
     }
     Anc {
        set sN [lindex $Pidf0(AncVidfN) $SenN]
        set Src ANCILLARY
        set vSen [lindex [lindex $Pidf0(AncSens) $SenN] 0]
        if { $vSen < 0 } { set vSen 0 } 
     }
   }

   set ReT ""
   set Len [llength $Tbls ]
   for {set I 0} { $I < $Len } {incr I } {
      set TList ""
      set tN [lindex $Tbls $I]
      set oP [lindex $Ops $I]
      set Fmt [lindex [lindex $SInfo($K,TFMT) $tN] $vSen]

      if {$Fmt >= 0 } {
         if {$Fmt == 0 } { set TOp 0 } else { set TOp 2 }
         set BaseOp [expr $oP % 10]
         set oP [expr abs($oP) ] 
         switch -exact -- $BaseOp {
            -3 { set BaseOp I ; set TOp 2  }
            -2 { set BaseOp ^  }
            -1 { set BaseOp %  }
             0 { set BaseOp =  }
             1 { set BaseOp +  }
             2 { set BaseOp -  }
             3 { set BaseOp *  }
             4 { set BaseOp /  }
             5 { set BaseOp &  }
             6 { set BaseOp |  }
             7 { set BaseOp >> }
             8 { set BaseOp << }
             9 { set BaseOp P  }
         }

         set ExtOp [expr int(($oP % 1000) / 10 )]
         switch -exact -- [expr int($oP / 1000)] {
              0      { set IBuf  0 ; set OBuf 0 }
              1      { set IBuf  0 ; set OBuf 1 }
              2      { set IBuf  1 ; set OBuf 0 ; set TOp 3}
              3      { set IBuf  0 ; set OBuf 1 ; set TOp 3}
              4      { set IBuf  1 ; set OBuf 2 ; set TOp 3}
              5      { set IBuf  0 ; set OBuf 3 ; set TOp 3}
              6      { set IBuf  2 ; set OBuf 0 ; set TOp 3}
              7      { set IBuf  2 ; set OBuf 1 ; set TOp 3}
              8      { set IBuf  3 ; set OBuf 2 ; set TOp 3}
              9      { set IBuf  1 ; set OBuf 3 ; set TOp 3}
             10      { set IBuf  3 ; set OBuf 0 ; set TOp 3}
             11      { set IBuf  3 ; set OBuf 1 ; set TOp 3}
             12      { set IBuf  0 ; set OBuf 2 ; set TOp 3}
             13      { set IBuf  2 ; set OBuf 3 ; set TOp 3}
             14      { set IBuf  0 ; set OBuf 4 ; set TOp 3}
             15      { set IBuf  0 ; set OBuf 5 ; set TOp 3}
             16      { set IBuf  0 ; set OBuf 6 ; set TOp 3}
             17      { set IBuf  1 ; set OBuf 4 ; set TOp 3}
             18      { set IBuf  2 ; set OBuf 5 ; set TOp 3}
             19      { set IBuf  3 ; set OBuf 6 ; set TOp 3}
             20      { set IBuf  0 ; set OBuf 2 }
             21      { set IBuf  0 ; set OBuf 3 }
             22      { set IBuf  0 ; set OBuf 4 }
             23      { set IBuf  0 ; set OBuf 5 }
             24      { set IBuf  0 ; set OBuf 6 }
             default { set IBuf  0 ; set OBuf 0 } 
         }
         incr IBuf
         incr OBuf
         set Tvar [lindex $SInfo($K,TVAR) $tN] 
         if {($Tvar != 1) && ($Tvar != 5 )} { 
            set HBuf 0 
         } else { set HBuf $IBuf }

         lappend TList $tN $IBuf $OBuf $ExtOp $BaseOp $TOp $HBuf
         lappend ReT $TList
      }
   }
   lappend ReT $Src $sN
   return $ReT
}
