# This routine loads commonly used VIDF and VIDF derived parameters

package provide TclUDF 1.0


proc UDFvidfVals { K } {
   global SInfo
   
   set G $K,GN
   set Key [lindex [split $K ","] 0]
   set Ver [lindex [split $K ","] 1]

   ReadVIDF $Key $Ver DATALEN 0 0 0 SInfo($G,DLEN)
   ReadVIDF $Key $Ver MAXNSS 0 0 0 SInfo($G,MAXSS)
   ReadVIDF $Key $Ver SEN 0 0 0 SInfo($G,NSEN)
   ReadVIDF $Key $Ver SMPID 0 0 0 SInfo($G,SMPID)
   ReadVIDF $Key $Ver SENMODE 0 0 0 SInfo($G,SENMODE)
   ReadVIDF $Key $Ver DAMETHOD 0 0 0 SInfo($G,DAMETHOD)
   ReadVIDF $Key $Ver NUMTBLS 0 0 0 SInfo($G,NTBLS)
   ReadVIDF $Key $Ver SWPLEN 0 0 0 SInfo($G,SCANLEN)
   ReadVIDF $Key $Ver TDWLEN 0 0 -1 SInfo($G,SLEN)
   ReadVIDF $Key $Ver STATES 0 0 -1 SInfo($G,MBLEN)
   ReadVIDF $Key $Ver DATATYPE 0 0 -1 SInfo($G,DTYPE)
   ReadVIDF $Key $Ver CALSETS 0 0 0 SInfo($G,ANUM)
   if {$SInfo($G,ANUM) > 0 } {
      ReadVIDF $Key $Ver CALWLEN 0 0 -1 SInfo($G,ABLEN)
      ReadVIDF $Key $Ver CALTARGET 0 0 -1 SInfo($G,ATARGET)
      ReadVIDF $Key $Ver CALUSE 0 0 -1 SInfo($G,AUSE)
   } else {
      set SInfo($G,ABLEN) ""
      set SInfo($G,ATARGET) ""
      set SInfo($G,AUSE) ""
   }
   ReadVIDF $Key $Ver TIMEOFF 0 0 -1 SInfo($G,TIMEOFF)

   switch -exact -- $SInfo($G,SENMODE) {
      0 -
      1 -
      4 -
      5       { set SInfo($G,ROWTIME) 1 }
      default { set SInfo($G,ROWTIME) 0 }
   }

#
#  For the present we are assuming that each defined UDF sensors is blocked 
#  at #  1,2,4 bytes in length with bit sized sensors being packed into larger 
#  sensors and then broken out using tables in the VIDF.
#

   set sList [lsort -integer -decreasing $SInfo($G,SLEN)]
   set SInfo($G,SBLEN) [UDFBSize [lindex $sList 0] 0]

   set Len [llength $SInfo($G,ABLEN)]
   set SInfo($G,ASBLEN) 0
   set SInfo($G,AGBLEN) 0
   set SInfo($G,APBLEN) 0
   set SInfo($K,NPANC)  0
   set CwdLen           0
   for {set I 0} {$I < $Len } {incr I} {
      set W [expr abs([lindex $SInfo($G,ABLEN) $I])]
      if { $W > $CwdLen } { set CwdLen $W }
      
      switch -exact -- [lindex $SInfo($G,ATARGET) $I] {
         0 { if { $W > $SInfo($G,ASBLEN) } { set SInfo($G,ASBLEN) $W } }
         2 { if { $W > $SInfo($G,AGBLEN) } { set SInfo($G,AGBLEN) $W } }
         3 { incr SInfo($K,NPANC)
             if { $W > $SInfo($G,APBLEN) } { set SInfo($G,APBLEN) $W } }
      }
   }

   set CwdLen [UDFBSize $CwdLen 0]
   set SInfo($G,APBLEN) [UDFBSize $SInfo($G,APBLEN) 0]
   set SInfo($G,AGBLEN) [UDFBSize $SInfo($G,AGBLEN) 0]
   set SInfo($G,ASBLEN) [UDFBSize $SInfo($G,ASBLEN) 0]

   if { $SInfo($K,VER)  < 0.0 } {
       if {$SInfo($G,SBLEN) < $CwdLen} { set SInfo($G,SBLEN) $CwdLen) }
       set SInfo($G,APBLEN) $SInfo($G,SBLEN)
       set SInfo($G,AGBLEN) $SInfo($G,SBLEN)
       set SInfo($G,ASBLEN) $SInfo($G,SBLEN)
   } elseif { [expr $SInfo($K,VER) - 2.1] <= 0.0 } {
       if {$SInfo($G,SBLEN) < $SInfo($G,ASBLEN)} {
          set SInfo($G,SBLEN) $SInfo($G,ASBLEN)
      } else { set SInfo($G,ASBLEN) $SInfo($G,SBLEN) }
   }

#
#  Check VIDF constants for specific values.  We need the azimuthal offsets
#     and some kind of elevation data.
#
#   cID = 1: Center elevation angles
#   cID = 2: Azimuthal offsets
#   cID = 4: Start elevation angles
#   cID = 5: Stop elevation angles
#   cID = 9: Elevation FWHM

   set iD1 0 ; set iD4 0 ; set iD5 0 ; set iD9 0

   ReadVIDF $Key $Ver NUMCONSTS 0 0 0 NConst
   for {set I 0} {$I < $NConst} { incr I } {
      ReadVIDF $Key $Ver CONSTID $I 0 0 CID
      switch -exact -- $CID {
         1  {  
            ReadVIDF $Key 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $Key 0 CONST $I 0 -1 V 1
            UDFScale Sc V CenTer 1
            set iD1 1
            unset Sc
            unset V
         }
         2  {  
	    ReadVIDF $Key $Ver CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $Key $Ver CONST $I 0 -1 V 1
            UDFScale Sc V SInfo($G,PHI) 0
            unset Sc
            unset V
         }
         4   {  
            ReadVIDF $Key 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $Key 0 CONST $I 0 -1 V 1
            UDFScale Sc V LoW 1
            set iD4 1
            unset Sc
            unset V
         }
         5   {  
            ReadVIDF $Key 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $Key 0 CONST $I 0 -1 V 1
            UDFScale Sc V HigH 1
            set iD5 1
            unset Sc
            unset V
         }
         9   {  
            ReadVIDF $Key 0 CONSTSCA $I 0 -1 Sc 1
            ReadVIDF $Key 0 CONST $I 0 -1 V 1
            UDFScale Sc V FwHm 1
            set iD9 1
            unset Sc
            unset V
         }
      }
   }

# OK we have what information we are going to get now lets hope we have
#   enough to build the start/stop theta array.

   set SInfo($G,THETA) ""

   if { $iD4 && $iD5 } {
      set nS [array size LoW] 
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) $LoW($I)
      }
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) $HigH($I)
      }
   } elseif { $iD1 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         set dT [expr FwHM($I) / 2.0]
         lappend SInfo($G,THETA) [expr $CenTeR($I) - $dT]
      }
      for { set I 0 } { $I < $nS } { incr I } {
         set dT [expr FwHM($I) / 2.0]
         lappend SInfo($G,THETA) [expr $CenTeR($I) + $dT]
      }
   } elseif { $iD4 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) $LoW($I)
      }
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) [expr $LoW($I) + $FwHm($I)]
      }
   } elseif { $iD5 && $iD9 } {
      set nS [array size FwHm] 
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) [expr $HigH($I) - $FwHm($I)]
      }
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) $HigH($I)
      }
   } elseif { $iD1 } {
      set nS [array size CenTeR] 
      for { set I 0 } { $I < $nS } { incr I } {
         lappend SInfo($G,THETA) $CenTeR($I)
      }
   }

   UDFtblAssem $K
}
