# RETURNS (list):
#            
#  ReT  dec_bday dec_eday  bmsec  bnsec  emsec  ensec

package provide TclUDF 1.0

proc UDFtimeSet { K N } {
   global SInfo ExDa

   set G $K,GN
   set S $K,SS
   set T $K,TM

#  LOAD the header times for return

   UDFretVar $K YEAR ExDa($N,BYR)
   UDFretVar $K DAY ExDa($N,BDY)
   set ExDa($N,EYR) $ExDa($N,BYR)
   set ExDa($N,EDY) $ExDa($N,BDY)

#  COMPUTE the start and stop time of the data and load it for return

   set Tm [UDFtimeData $K $N ]
   set ExDa($N,BMSEC) [lindex $Tm 2]
   set ExDa($N,BNSEC) [lindex $Tm 3]
   set ExDa($N,EMSEC) [lindex $Tm 4]
   set ExDa($N,ENSEC) [lindex $Tm 5]

#  IF we had to back off a day either in the start and/or stop times we 
#    need to take that into account by modifing the start and/or stop
#    year and day numbers

   if { [lindex $Tm 0] == 1 } {
      incr ExDa($N,BDY) -1
      if { $ExDa($N,BDY) < 1 } {
         incr ExDa($N,BYR) -1
         set ExDa($N,BDY) [TUyearLeap $ExDa($N,BYR)]
      }
   }

   if { [lindex $Tm 1] == 1 } {
      incr ExDa($N,EDY) -1
      if { $ExDa($N,EDY) < 1 } {
         incr ExDa($N,EYR) -1
         set ExDa($N,EDY) [TUyearLeap $ExDa($N,EYR)]
      }
   }

#  NOW we need to correct for the opposite problem.  The Msec greater
#     than one day.  But first save the raw millisecond times as they
#     are used in the computation of the spin angles

   set ExDa($N,RBMSEC) $ExDa($N,BMSEC)
   set ExDa($N,REMSEC) $ExDa($N,EMSEC)

   set DiY [TUyearLeap $ExDa($N,BYR)]
   incr ExDa($N,BDY)  [expr int($ExDa($N,BMSEC) / 86400000) ]
   set ExDa($N,BMSEC) [expr $ExDa($N,BMSEC) % 86400000 ]
   if {$ExDa($N,BDY) > $DiY } {
      set ExDa($N,BDY) 1
      incr ExDa($N,BYR)
   }

   incr ExDa($N,EDY)  [expr int($ExDa($N,EMSEC) / 86400000) ]
   set ExDa($N,EMSEC) [expr $ExDa($N,EMSEC) % 86400000 ]
   if {$ExDa($N,EDY) > $DiY } {
      set ExDa($N,EDY) 1
      incr ExDa($N,EYR)
   }
}
