#  Load up all tables except ASCII tables.  Tables are loaded into binary
#    arrays.  This makes access from the C interface prgrams much simpler.

package provide TclUDF 1.0

proc UDFtblAssem { K } {
   global SInfo Tbls$K
   
   set G $K,GN
   set P $K,PT
   set Key [lindex [split $K ","] 0]
   set Ver [lindex [split $K ","] 1]

#  PROVIDE a link to the table data

   set TmP Tbls$K
   upvar 0 $TmP Tv

#  LOOP over all the tables in the VIDF, processing only the integer
#    tables.  ASCII tables (TType = 1) are ignored.

   set Pos 0
   for {set I 0} {$I < $SInfo($G,NTBLS) } {incr I} {
      ReadVIDF $Key $Ver TBLTYPE  $I 0  0 TType
      if {$TType == 1} { continue }

#  THIS is the number or sensors which are defined in the VIDF for this
#     UDF definition. 

      ReadVIDF $Key $Ver SEN $I 0  0 SenN

#  THIS is the type of variable on which this table operates

      ReadVIDF $Key $Ver TBLVAR   $I 0 -1 TVar
      lappend SInfo($K,TVAR) $TVar

#  THIS is the format of the table

      ReadVIDF $Key $Ver TBLFMT   $I 0 -1 TmP 
      lappend SInfo($K,TFMT) $TmP

#  AT this point we need to determine the number of entries in the table 
#    which are associated with each defined VIDF sensor.  This is complex
#    because of the number of interdependencies.   
#
#  A table is either a lookup table (TblFmt = 0) or defines a number of 
#    polynomial coefficients (TblFmt > 0).  For a lookup table, the number
#    of elements associated with a sensor depends on what the table is
#    modifing (raw sensor data: 2^{sensor_bit_length}; raw scan data:
#    max scan length; raw status data: max status values; non-raw data:
#    2 ^ {tbl_expand}).  
#
#  THERE is one size and table type determined for each VIDF sensor for 
#    each defined table.  Within the UDF Tcl Code all lookup tables have  
#    a table type (TOP) of 0 and non-lookup tables a type of 2.

      set TList ""
      set OList ""
      set End [llength $TmP]
      ReadVIDF $Key $Ver TBLEXPAND   $I 0 -1 TExp
      for {set J 0} {$J < $End } {incr J} { 
         set Fmt [lindex $TmP $J]
         if {$Fmt > 0 } {
            lappend TList $Fmt
            lappend OList 2
         } else {
            switch -exact -- $TVar {
               0  { set Size [expr int(pow(2., [lindex $SInfo($G,SLEN) $J]))] }
               1  -
               5  { set Size [expr int(pow(2.0, $TExp))] }
               2  { set Size $SInfo($G,SCANLEN) }
               4  { set Size [lindex $SInfo($G,SLEN) $J] }
               6  { set Size [lindex $SInfo($G,MBLEN) $J] }
               7  { set Size [lindex $SenN $J] }
               8  { set Size 0 }
               default  { 
                    set Size [expr int(pow(2., [lindex $SInfo($G,ABLEN) $J]))]
                  }
            }
            lappend TList $Size
            lappend OList 0
         }
      }

      lappend SInfo($K,TELEM) $TList
      lappend SInfo($K,TOP) $OList

# GET the table scaling values and sensor dependent offsets into the raw 
#    table values

      ReadVIDF $Key $Ver TBLSCA   $I 0 -1 TSca 1
      ReadVIDF $Key $Ver TBLOFF   $I 0 -1 TOff
      lappend SInfo($K,TOFF) $TOff

# GET the raw table values and the number of defined scaling values.  If
#   the latter is < 0 then there is only a single scaling value for all
#   table values associated with any sensor otherwise each defined table
#   value has it own scaling value.

      ReadVIDF $Key $Ver TBL   $I 0 -1 TVal 1
      ReadVIDF $Key $Ver TBLSCASZ $I 0  0 NSca

#     if {$NSca < 0 } {
#        set SLen [expr [array size TSca] - 1]
#        set Last $TSca($SLen)
#        set J 0
#        while {($TSca($J) == $Last) && ($J < $SLen) } { incr J }
#        if {$J == $SLen } { set Fmt 1 } else { set Fmt 3 }
#     } else {
#        if {$NSca == 1 } { set Fmt 1 } else { set Fmt 2 }
#     }

      ReadVIDF $Key $Ver CRITACTSZ  $I 0 -1 TmP
      if {$TmP > 0 } {
         ReadVIDF $Key $Ver CRITSTATUS   $I 0 -1 TmP
         lappend SInfo($K,TCMODE) $TmP
         ReadVIDF $Key $Ver CRITOFF   $I 0 -1 TmP
         lappend SInfo($K,TCOFF) $TmP
         ReadVIDF $Key $Ver CRITACTION   $I 0 -1 TmP
         lappend SInfo($K,TCTOTBL) $TmP
      } else {
         lappend SInfo($K,TCMODE)  ""
         lappend SInfo($K,TCOFF)   ""
         lappend SInfo($K,TCTOTBL) ""
      }

      UDFScale TSca TVal Tv 2 $Pos $TOff 
      lappend SInfo($P,TOTBL) $Pos
      incr Pos [array size TVal]
      unset TSca TVal
   }
}
