#  Apply a table to a value

#package provide TclUDF_C 1.0
package provide TclUDF 1.0

proc UDFtblApply { K Op tOff nEle V } {
   global SInfo Tbls$K
   
   set P $K,PT

   set TmP Tbls$K
   upvar 0 $TmP Tv

   switch -exact -- $Op {
      0  {  set ToData @[expr 8 * (int($V) + $tOff)]d
            binary scan $Tv $ToData ReT 
         }
      1  {  if { $nEle == 1 }  {
               set ReT 0
            } else { 
               set ToData @[expr 8 * $tOff]d3
               binary scan $Tv $ToData1 tV
               set dV1 [expr [lindex $tV 0] - [lindex $tV 1]]
               if { $nEle > 3 } {
                  set dV2 [expr [lindex $tV 1] - [lindex $tV 2]]
                  set Prod [expr $dV1 * $dV2]
               } else { set Prod 1 }

               if { $Prod > 0 } {
                  set Low 0
                  set High [expr $nEle - 1]
                  set Max $High
                  if { $dV1 < 0.0 } {
                     while { $Low <= $High } {
                        set Mid [expr int(($Low + $High) / 2))
                        set ToMid @[expr 8 * $Mid]d
                        binary scan $Tv $ToData3 mV 
                        if { $V <= $mV } {
                           set High [expr $Mid - 1 ]
                        } else { set Low [expr $Mid + 1] }
                     }
                  } else {
                     while { $Low <= $High } {
                        set Mid [expr int(($Low + $High) / 2))
                        set ToMid @[expr 8 * $Mid]d
                        binary scan $Tv $ToData3 mV 
                        if { $V <= $vM } {
                           set High [expr $Mid + 1 ]
                        } else { set Low [expr $Mid - 1] }
                     }
                  }

                  if {(($Low < 0) || ($Low > $Max)) || \
                                    (($High < 0) || ($High > $Max)) } {
                     set ReT $Mid
                  } else {
                     set ToHi @[expr 8 * $High]d
                     binary scan $Tv $ToHi hV 
                     if { $V > $hV } {
                        set dV1 [expr $V - $hV]
                     } else { set dV1 [expr $hV - $V] }
                     set ToLo @[expr 8 * $Low]d
                     binary scan $Tv $ToLo lV 
                     if { $V > $lV } {
                        set dV2 [expr $V - $lV]
                     } else { set dV2 [expr $lV - $V] }
                     if {$dV1 >= $dV2 } { set ReT $Low } else { set ReT $High }
                  }
               }
            } else { set ReT $V } 
         }
      2  {  set X 1.0
            set ToData @[expr 8 * $tOff]d$nEle
            binary scan $Tv $ToData tV
            set ReT [lindex $tV 0]
            for {set I 1} {$I < $nEle } {incr I} {
               set X [expr $X * $V ]
               set ReT [expr $ReT + $X * [lindex $tV $I]]
            }
         }
      3  {  set ReT $V }
   }

   return $ReT
}
