#  THIS procedure resets all of the sensor associated parameters.

package provide TclUDF 1.0

proc UDFresetAccum { K } {
   global SInfo ExDa 

   set G $K,GN
   set P $K,PT
   set S $K,SS
   set T $K,TM

#  GET the effective number of sensors and the samples per sensor in this 
#     sensor set.  
  
   set TotCols [expr $SInfo($K,NCOLS) * $SInfo($K,NSEN) ]

   set NSmP $SInfo($K,NSMP) 
   if { ($SInfo($K,NSMP) != 1) && ($SInfo($G,SMPID) != 2) } {
      if { $SInfo($G,DAMETHOD) == 3 } {
         UDFretVar $K SCAN ScaN 
         set NSmP [expr abs([lindex $ScaN 1] - [lindex $ScaN 0]) * $NSmP]
      } elseif { $SInfo($G,DAMETHOD) == 1 } {
         set NSmP $SInfo($G,SCANLEN) 
      } elseif { $SInfo($G,DAMETHOD) == 2 } {
         UDFretVar $K SCAN ScaN
         set N [expr $SInfo($K,NSMP) - 1 ]
         set NSmP [expr abs([lindex $ScaN $N] - [lindex $ScaN 0]) + 1]
      }
   }   

   set TC [expr $TotCols - 1]
   set SS [expr $NSmP - 1]
   set SInfo($T,TOTMS) [expr $SInfo($T,TOTMS) + $SInfo($T,ROWMS) * $TC + \
                        $SInfo($T,COLMS) * $SS  + $SInfo($T,SRSTMS) + \
                        $SInfo($T,SSRSTMS) + $SInfo($T,SMPMS)]

   set SInfo($T,TOTNS) [expr $SInfo($T,TOTNS) + $SInfo($T,ROWNS) * $TC + \
                        $SInfo($T,COLNS) * $SS  + $SInfo($T,SRSTNS) + \
                        $SInfo($T,SSRSTNS) + $SInfo($T,SMPNS)]
}
