package provide TclUDF 1.0

proc UDFreadHDR { K HNum} {
   global SInfo ByTe_4 ByTe_2

   set G $K,GN
   set P $K,PT
   set S $K,SS

#  ONLY read header if it is different from the last header read

   if { $SInfo($K,CHOFF) == [lindex $SInfo($K,HOFFS) $HNum]} { return 1 }

#  IF the offset to the header is negative then EOF

   if { [lindex $SInfo($K,HOFFS) $HNum] < 0 } { return -1 }

#  READ HEADER - read two byte length first which gives the header size then
#     read the header proper.  Save the current header byte offset for future
#     comparison and set the header status to indicate that a new header was 
#     read in

   set fh $SInfo($K,HFD)
   fconfigure $fh -translation binary
   TUfileSeek $fh [lindex $SInfo($K,HOFFS) $HNum] start 
   set HDR [read $fh 2]
   binary scan $HDR $ByTe_2 HSz
   set SInfo($K,HEADER) [read $fh $HSz]
   set SInfo($K,CHOFF) [lindex $SInfo($K,HOFFS) $HNum]
   set SInfo($K,HSTATUS) 1

#
#  Now set some of the current header variables.  Note that NCOLS will be
#  automatically set to 1 if this is not a matrix based UDF.  Also recompute
#  the number of ancillary values present in the sensor set.  This can
#  change if either the number of sensors or samples change.
#

   UDFretVar $K NSEN SInfo($K,NSEN)
   UDFretVar $K NSMP SInfo($K,NSMP)
   UDFretVar $K TOTCOL SInfo($K,NCOLS)
   UDFancNums $K

#
#  Reset some of the pointers to the varaible sized data.  Pointer are reset
#  not only to header data but to data record fields also
#

   if {$SInfo($G,SMPID) != 3 } {
       set SInfo($P,TOSCAN) 26
   } else { set SInfo($P,TOSCAN) 32 }

   if {$SInfo($G,SMPID) == 2 } {
      set SInfo($P,TOSEN) [expr $SInfo($P,TOSCAN) + 2]
   } else {
      set SInfo($P,TOSEN) [expr $SInfo($P,TOSCAN) + 2 * $SInfo($K,NSMP)] }

   set SInfo($P,TOQUAL) [expr $SInfo($P,TOSEN) + 2 * $SInfo($K,NSEN)]
   set SInfo($P,TOMODE) [expr $SInfo($P,TOQUAL) + $SInfo($K,NSEN)]

#
#  Determine the byte size of the current sensor set data, the current sensor 
#  set genreal  ancillary data, and of the whole sensor set.
# 
   
   set TC [expr $SInfo($K,NSEN) * $SInfo($K,NCOLS)]
   set SInfo($S,SBYTES) [expr $SInfo($K,NSMP) * $TC * $SInfo($G,SBLEN)]
   set SInfo($S,SSBYTES) [expr $SInfo($S,ASBYTES) + $SInfo($S,SBYTES) \
                                               + $SInfo($S,AGBYTES)]

   UDFtimeComps $K
   return 1
}
