package provide TclUDF 1.0

proc UDFpidfUnit { N fd } {
   global Pidf$N

   set TmP Pidf$N
   upvar 0 $TmP P

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}

   set uL [ list Id LId Min Max Sca Lab LDes SDes Tbls Ops]
   set uD(0)  -1 
   set uD(1)  -1 
   set uD(2)   0 
   set uD(3)   1 
   set uD(4)   0 
   set uD(5)  "" 
   set uD(6)  "" 
   set uD(7)  "" 
   set uD(8)  "" 
   set uD(9)  "" 
   set oPs    "" 

   gets $fd Line
   regexp "\[ \t\]*(.)" $Line M End
   while { [string compare $End "\}"] != 0 } {
      regexp "$P1" $Line M T Fld V Com
      if [string match string* $T] { regexp "$P2" $Line M T Fld V Com }
      if ![string match struct* $T] { 
         switch -glob -- $Fld {
            id*                 {  set uD(0)     $V        }
            local_id*           {  set uD(1)     $V        }
            min*                {  set uD(2)     $V        }
            max*                {  set uD(3)     $V        }
            unit_scaling*       {  set uD(4) [expr $V - 1] }
            unit_label*         {  set uD(5)     $V        }
            long_description*   {  set uD(6)     $V        }
            short_description*  {  set uD(7)     $V        }
            tbl_app_flag*       {  lappend uD(8) $V        }
            tbl_app_oper*       {  lappend oPs   $V        }
         }
      }
      gets $fd Line
      regexp "\[ \t\]*(.)" $Line M End
   }

   set Len [llength $oPs]
   for { set I 0 } { $I < $Len } { incr I } {
      switch -exact -- [lindex $oPs $I] {
           ^ { lappend uD(9) -2  }
          -% { lappend uD(9) -1  }
           = { lappend uD(9)  0  }
           + { lappend uD(9)  1  }
           - { lappend uD(9)  2  }
           * { lappend uD(9)  3  }
           / { lappend uD(9)  4  }
           & { lappend uD(9)  5  }
           | { lappend uD(9)  6  }
          >> { lappend uD(9)  7 }
          << { lappend uD(9)  8 }
           P { lappend uD(9)  9  }
           default { lappend uD(9) [lindex $oPs $I] }
       }
   }

   set Len [llength $uL]
   for { set I 0 } { $I < $Len } { incr I } {
      lappend P(Unit[lindex $uL $I]) $uD($I)
   }

   lappend P(UnitNtbls) [llength $uD(8)]
   incr P(NUnits)
}
