#
#  This procedure opens a DBF file and reads the header information 
#

package provide TclUDF 1.0

proc UDFopenDBF { DBFname } {
   global DBFNumRecs DBFNumFlds DBFFldNames DBFFldTypes DBFFldLens \
          DBFHLen DBFRecLen DBFfd ByTe_4 ByTe_2

#
#  Open file as binary only, read header block and pull out the total number
#  of records in the file as well as the number of fields per record
#

   if [catch {open $DBFname r} DBFfd ] {
       puts stderr "CANNOT OPEN $DBFname"
       return -1
   }
   fconfigure $DBFfd -translation binary
   set Head [read $DBFfd 32]

#  binary scan $Head "@4$ByTe_4" DBFNumRecs 
#  binary scan $Head "@8$ByTe_2" DBFHLen 
#  binary scan $Head "@10$ByTe_2" DBFRecLen 
   binary scan $Head "@4i" DBFNumRecs 
   binary scan $Head "@8s" DBFHLen 
   binary scan $Head "@10s" DBFRecLen 

   set DBFHLen [expr $DBFHLen + 1]
   set Rest [expr $DBFHLen - 32]
   set Head [read $DBFfd $Rest]

   set DBFNumFlds [expr int($Rest /  32)]
   set DBFFldNames ""
   set DBFFldTypes ""
   set DBFFldLens ""
   set J 0
   for { set I 0 } { $I < $DBFNumFlds } { incr I } {
       binary scan $Head @${J}a11aii NamE Type TmP Len
       lappend DBFFldNames $NamE
       lappend DBFFldTypes $Type
       lappend DBFFldLens $Len
       incr J +32
   }
}
