#  THIS opens the next Header/Data file in the list of header/data files
#    generated in the FileOpen call and positions the file pointer to 
#    an input starting time.
#
#   RETURNS:
#       1 - successful
#      -1 - no more data

package provide TclUDF 1.0

proc UDFnextFile { kV } {
   global SInfo ByTe_4 ByTe_2 ExDa

   set G $kV,GN
   set S $kV,SS

# CLOSE the currently open header and data files

   catch { close $SInfo($kV,DFD) } MsG
   catch { close $SInfo($kV,HFD) } MsG
   set SInfo($kV,HFD)  ""
   set SInfo($kV,DFD)  ""

# INCREMENT to the next file in the list.  If this puts us beyond the last
#   file then we are done.

   set Len [llength $SInfo($kV,HDLIST)]
   if { [expr $SInfo($kV,HDNUM) + 1] >= $Len } { return -1 }
  
# SET the current time.  In this case it is set to the ending time of'
#    the previous file.

    set cTm [lindex [lindex $SInfo($kV,HDLIST) $SInfo($kV,HDNUM)] 2]

#  NOW loop over the next files to see which file the time is contained in.
#    Should be the first but you never know

   set InBounds 5
   set I $SInfo($kV,HDNUM)
   while { ($I < $Len) && ($InBounds > 1) } {
      incr I
      set bTm [lindex [lindex $SInfo($kV,HDLIST) $I] 1]
      set eTm [lindex [lindex $SInfo($kV,HDLIST) $I] 2]
      set tList [lsort -ascii -increasing [list $bTm $eTm $cTm]]
      set InBounds [lsearch -exact $tList $cTm]
   }

   if { $I == $Len } { return -1 }
   set SInfo($kV,HDNUM) $I

# OPEN the next file 

   UDFfileOpen $kV
   
# Break apart the starting time into its components

   scan $cTm "%4d%3d%8d" Yr Dy Msec
   set Hr [expr $Msec / 3600000 ]
   set Mn [expr ($Msec % 3600000) / 60000 ]
   set Ss [expr ($Msec % 60000) / 1000 ]

# Break apart kV 

   set Key [lindex [split $kV ","] 0]
   set Ver [lindex [split $kV ","] 1]

# POSITION into the file
   
# SET local copies of the open header/data filedescriptors and configure them
#    so that they are reading binary data

   set fd $SInfo($kV,DFD)
   set fh $SInfo($kV,HFD)
   fconfigure $fd -translation binary
   fconfigure $fh -translation binary

#  FIGURE out how many data records there are in the data file

   set Fname [file join $SInfo($kV,IHDPATH) \
                  [lindex [lindex $SInfo($kV,HDLIST) $SInfo($kV,HDNUM)] 0]D]
   set FLen [file size $Fname]
   set NumRec [expr int($FLen / $SInfo($G,DLEN))]

#  DO a quick binary search of the data file to establish which data record
#    the input lies in.

   set Low 0
   set High [expr $NumRec - 2]
   set FirstTime 1
   set Nsec 0
   while {$Low <= $High} {
      set Mid [expr int(($Low + $High)/2)]
      set Bytes [expr $SInfo($G,DLEN) * $Mid]
      UDFreadDATA $kV $Bytes
      UDFreadHDR $kV 0
      UDFretVar $kV YRDY yD 1
      UDFretVar $kV TIME Tm
      set fTm [format "%4d%03d%08d" $yD(0) $yD(1) $Tm]
      set tList [lsort -ascii -increasing [list $fTm $cTm]]
      set Pos [lsearch -exact $tList $cTm]
      if {$Pos == 0 } { 
         if ![string match $fTm $cTm] {
            set High [expr $Mid - 1] 
        } else { set High -10 }
      } else { set Low [expr $Mid + 1] } 
   }

#  NOW do a final adjustment to get to the start of the record.  This consists
#      of reading the next record and making sure that the requested time is
#      between the current and this record.  If not - search a bit forward or
#      backward.

   set Done 0
   set lTm [format "%4d%03d%08d" $yD(0) $yD(1) $Tm]
   while { $Done == 0 } {
      if { [UDFreadDATA $kV -1] == 0 } {
         UDFreadHDR $kV 0
         UDFretVar $kV YRDY yD 1
         UDFretVar $kV TIME Tm
         set nTm [format "%4d%03d%08d" $yD(0) $yD(1) $Tm]
         set tList [lsort -ascii -increasing [list $lTm $cTm $nTm]]
         set Pos [lsearch -exact $tList $cTm]
         switch -exact -- $Pos {
             0 {   set Cen [lindex $tList 1]
                   if ![string match $cTm $Cen] {
                      set Bytes [expr -3 * $SInfo($G,DLEN)]
                      if { [TUfileSeek $fd $Bytes current] >= 0 } {
                         UDFreadDATA $kV -1
                         UDFreadHDR $kV 0
                         UDFretVar $kV YRDY yD 1
                         UDFretVar $kV TIME Tm
                         set lTm [format "%4d%03d%08d" $yD(0) $yD(1) $Tm]
                         incr Mid -1
                      } else { set Done 1 }
                   } else { set Done 1 }
                }
             1  {  incr Mid 
	           set Done 1
                }
             2  {  incr Mid
                   set lTm $nTm
                }
         }
      } else { set Done 1 }
   }

   set Bytes [expr $Mid * $SInfo($G,DLEN)]
   TUfileSeek $fd $Bytes start
   set rV [UDFreadDATA $kV $Bytes]
   UDFreadHDR $kV 0

#
#  Initialize some of the read variables here
#

   UDFvarInits $kV 1
   UDFretVar $kV YRDY yD 1
   UDFretVar $kV TIME Tm

   if {[string match FINE $SInfo($kV,FPOS)] == 1 } {
       set Done 0
       set N T
       while { $Done == 0 } {
          ReadUDF $Key $Ver $N -1 0 0 0 
          set lTm [format "%4d%03d%08d" $ExDa($N,BYR) $ExDa($N,BDY) \
                                        $ExDa($N,BMSEC) ]
          set nTm [format "%4d%03d%08d" $ExDa($N,EYR) $ExDa($N,EDY) \
                                        $ExDa($N,EMSEC) ]
          set tList [lsort -ascii -increasing [list $lTm $cTm $nTm]]
          set Pos [lsearch -exact $tList $cTm]
          if {$Pos == 2 } {
             set SInfo($Key,$Ver,RSTATUS) 1
          } else { set Done 1 }
       }
       UDFunsetExDa T
   }
   set SInfo($Key,$Ver,RSTATUS) -1
   return 1
}
