# GET the paths for a given PMEI
#
#  UDFPaths is an array of the various paths.  Elements are
#  
#  UDFPaths(0) - PIDF path
#  UDFPaths(1) - Database path
#  UDFPaths(2) - UDF Data path

package provide TclUDF 1.0

proc UDFdirPaths { Pr Mi Ex In } {
   global env UDFPaths CFGPaths

# CHECK to see if the CFG paths have been established and if not then
#    set them up

   if ![array exists CGFPaths] { UDFcfgPaths }

# ESTABLISH the project:mission and initialize the paths
 
   set PM $Pr:$Mi
   set UDFPaths(0) ""
   set UDFPaths(1) ""
   set UDFPaths(2) ""
   set Root [string index $env(UDF_DATA) 0]

# If there are Specific Path Values Use those instead of the Endemic Values

   set J 0
   set K 2
   set L 3
   for { set I 0 } { $I < 3 } { incr I ; incr J 4 ; incr K 4 ; incr L 4 } {
      set Pos [lsearch -exact $CFGPaths($K) $PM]
      if { $Pos >= 0 } {
         set UTmp($I) [lindex $CFGPaths($L) $Pos]
      } else {
         set Pos [lsearch -exact $CFGPaths($K) $Pr]
         if { $Pos >= 0 } {
            set UTmp($I) [lindex $CFGPaths($L) $Pos]
         } else { set UTmp($I) $CFGPaths($J) }
      }
   }

# replace any environment variables in the path names and take care of the
# % at the end of the path should it be present

   for {set I 0} {$I < 3} { incr I} { 
      set Paths [split $UTmp($I) "/"]
      set Depth [llength $Paths]
      for {set K 0} { $K < $Depth } { incr K } {
         if [string match "$*" [lindex $Paths $K]]  {
            append UDFPaths($I) $env([string trimleft [lindex $Paths $K] "$"])
         } else {
            if { [string length [lindex $Paths $K]] == 0 } {
               set UDFPaths($I) [file join $UDFPaths($I) $Root]
            } else {
               set UDFPaths($I) [file join $UDFPaths($I) [lindex $Paths $K]]
            }
         }
      }
   }

   for {set I 0} {$I < 3} { incr I} { 
      if [string match "*%" $UDFPaths($I)]  {
         set UDFPaths($I) [string trimright $UDFPaths($I) "%"]
      } else {
         set UDFPaths($I) [file join $UDFPaths($I) $Pr $Mi $Ex $In]
      }
   }

   set UDFPaths(1) [file join $UDFPaths(1) Database]
}
