#  THIS package checks to see if file promote is activated and if it is does
#    a file need to be promoted.  Promotions are made on a plan ahead type
#    of stratagy where all files within the specified time range are retrieved
#    prior to usage.  To see if anything needs to be promoted, the following
#    critera is used.  First the files within the requested time range are
#    checked.  If there are time gaps larger than specified for the PMEIV
#    then the entire range is promoted.  Second if the requested time has 
#    either of its end points outside the available file time range then the
#    entire time range is promoted.  
#
#  THE acceptable time gaps for a project.mission can be specified in the
#     PromoteIf varaible in the UDFInit routine.  If not specified it is
#     set to 1 minute.

package provide TclUDF 1.0

proc UDFchkPromote { ReQ KeY Yb Db Msb Ye De Mse } {
   global SInfo env PromoteIf

   if [string match OFF $SInfo(AutoPr)] { return 1 }

# INVERT the UDF key to return the ascii PMEIV values

   UDFkeyInfo $KeY 0 PMEIV

# SEE if there is a minimum file gap time specified for this data set.  The
#   specification can be at any level.  The time gap is set in seconds and
#   can be fractional

   set tGap 10
   set IndeX ""
   for { set I 0 } { $I < 5 } { incr I } {
       append IndeX $PMEIV($I) 
       if [info exists PromoteIf($IndeX) ] { set tGap $PromoteIf($IndeX) }
       append IndeX .
   }

# FIND out what data is available online and sort it so that it is
#   increasing in time

   if [string match SEARCHV $ReQ] {
     set dataTm [DBgetEntries $KeY $Yb $Db $Msb $Ye $De $Mse I]
   } else { set dataTm [DBgetEntries $KeY $Yb $Db $Msb $Ye $De $Mse HD] }
   set dataTm [lsort -ascii -increasing -index 0 $dataTm]

# SET the promote status to NO

   set Status NO

# NOW loop over all the returned files and make sure there are no gaps which
#    are larger than is be allowed.  Also save the insert times.

   set nE [expr [llength $dataTm] - 1]
   set I 0
   set J 1
   while  { ($I < $nE) && [string match NO $Status] } {
      set T1 [lindex [lindex $dataTm $I] 2]
      set yA [string trimleft [string range $T1 0 3] 0]
      set dA [string trimleft [string range $T1 4 6] 0]
      set tA [string trimleft [string range $T1 7 14] 0]
      if { $tA == 86400000 } {
         incr dA
         if { $dA > [TUyearLeap $yA] } {
            incr yA
            set dA 1
         }
      }
      set T2 [lindex [lindex $dataTm $J] 1]
      set yB [string trimleft [string range $T2 0 3] 0]
      set dB [string trimleft [string range $T2 4 6] 0]
      set tB [string trimleft [string range $T2 7 14] 0]
      if { [string length $tA] == 0 } { set tA 0 }
      if { [string length $tB] == 0 } { set tB 0 }

      set dT 0
      for { set Y $yA } { $Y < $yB } { incr Y } {
         set dT [expr $dT + [TUyearLeap $Y]]
      }

# GET the time gap to seconds

      set dT [expr $dT * 86400.0 + ($dB - $dA)/1000.0]
      if { $dT > $tGap } { set Status YES } 

      incr I
      incr J
   }

# IF there is nothing in the database for this time period then we need
#   to promote something

   if { $nE < 0 } { set Status YES }

# ONE last general check. We need to try and promote if the requested 
#   begin and end times preceed or exceed respectively the data online

   if [string match NO $Status] { 
      set dtB [lindex [lindex $dataTm 0] 1]
      set dtE [lindex [lindex $dataTm $nE] 2]
      set utB [format "%4d%03d%08d" $Yb $Db $Msb]
      set utE  [format "%4d%03d%08d" $Ye $De $Mse]
      if { [DBtimeCmp $dtB $dtE $utB $utE] != 2 } { set Status YES }
   }

# AND finally the VIDF check.  IF this is a VIDF file then we need to
#   see if it needs to be promoted even through it may already exist.

   if { [string match SEARCHV $ReQ] && ( $PromoteIf(VIDFPr) >= 0 ) } {
      set ToDay [clock format [clock seconds] -format %Y%m%d]
      scan $ToDay %4d%2d%2d Yr Mo Dy
      set Tm [TUtimeFmt 5 $Yr $Mo $Dy]
      scan $Tm %4d%3d cY cD

      set I 0
      while  { ($I <= $nE) && [string match NO $Status] } {
         set Insert [lindex [lindex $dataTm $I] 3]
         scan $Insert %4d%2d%2d Yr Mo Dy
         set Tm [TUtimeFmt 5 $Yr $Mo $Dy]
         scan $Tm %4d%3d iY iD
	 set dTm [expr 365 * ($cY - $iY) + $cD - $iD]
	 if { $dTm >= $PromoteIf(VIDFPr) } { set Status YES }
	 incr I
      }
   }

   if [string match YES $Status] {
      UDFfilePromote $ReQ $KeY $Yb $Db $Msb $Ye $De $Mse 
   } 
}
