# Find all possible paths
#
#  CFGPaths(0)  - endemic PIDF path - used if specific path not set up
#  CFGPaths(1)  - number of specific Pidf paths found 
#  CFGPaths(2)  - the specific Pidf path ID 
#  CFGPaths(3)  - the specific Pidf path  
#  CFGPaths(4)  - endemic Database path - used if specific path not set up
#  CFGPaths(5)  - number of specific Database paths found
#  CFGPaths(6)  - the specific Database path ID 
#  CFGPaths(7)  - the specific Database path  
#  CFGPaths(8)  - endemic UDF Data path - used if specific path not set up
#  CFGPaths(9)  - number of specific UDF data paths found
#  CFGPaths(10) - the specific UDF Data path ID 
#  CFGPaths(11) - the specific UDF Data path  

package provide TclUDF 1.0

proc UDFcfgPaths { } {
   global env CFGPaths UDFdataOrder tcl_platform

   if ![info exists UDFDataOrder] { 
      TUreadUDFrc UDF askANS

      if ![info exists askANS(Data)] {
          set UDFdataOrder $tcl_platform(byteOrder)
      } else { set UDFdataOrder $askANS(Data) }
   }

   if [array exists CGFPaths] { return }

   set DB [file join $env(UDF_HOME) config DB.cfg]
   if [catch {open $DB r} fDB] {
      puts stderr "CANNOT OPEN $DB"
      exit
   }
                                                                                
   set AllFound 0
   while { $AllFound < 3 } {  
      set line [UDFcfgSkipLine $fDB]
      regexp {([^\.]*).([A-Za-z]*)[ "]*([^"]*)} $line M V ID Path
      if { [string match PidfPath* $V] == 1 } {
         set CFGPaths(0) $Path
         incr AllFound
      }
      if { [string match DatabasePath* $V] == 1 } {
         set CFGPaths(4) $Path
         incr AllFound
      }
      if { [string match PostTimePath* $V] == 1 } {
         set CFGPaths(8) $Path
         incr AllFound
      }
   }

   set CFGPaths(1) 0
   set CFGPaths(5) 0
   set CFGPaths(9) 0

   set line [UDFcfgSkipLine $fDB]
   while {[string length $line] > 0 } {
      regexp {([^\.]*).([^\.]*).([A-Za-z]*)[ "]*([^"]*)} $line M I V ID Path
      if {[string match PidfPath* $V] == 1} {
         incr CFGPaths(1)
         lappend CFGPaths(2) $I
         lappend CFGPaths(3) $Path
      }
      if {[string match DatabasePath* $V] == 1} {
         incr CFGPaths(5)
         lappend CFGPaths(6) $I
         lappend CFGPaths(7) $Path
      }
      if {[string match PostTimePath* $V] == 1} {
         incr CFGPaths(9)
         lappend CFGPaths(10) $I
         lappend CFGPaths(11) $Path
      }
      set line [UDFcfgSkipLine $fDB]
   }

   close $fDB
}
