#  Ancillary Data Items which need to be reset with each header call
#  These include:
#    
#    1) Computing the number of ancillary data values in each set of
#       ancillary data.
#
#    2) Determining the total number of values in each of the three
#       catagories of ancillary data types

package provide TclUDF 1.0

proc UDFancNums { K } {
   global SInfo
   
   set G $K,GN
   set S $K,SS
   set Ka $K,ASETN

   set SInfo($K,NSANC) 0
   set SInfo($K,NGANC) 0
   set SInfo($Ka) ""
   if {$SInfo($G,ANUM) == 0} { 
      set SInfo($S,AGBYTES) 0
      set SInfo($S,ASBYTES) 0
      return 
   } 

   for {set I 0} {$I < $SInfo($G,ANUM) } {incr I } {
      set Rep [lindex $SInfo($G,AUSE) $I]
      if {$Rep == 0 } {
         lappend SInfo($Ka) 1
      } else {
         if { [expr $SInfo($K,NSMP) % $Rep] == 0 } {
            lappend SInfo($Ka) [expr int($SInfo($K,NSMP) / $Rep)]
         } else { 
            lappend SInfo($Ka) [expr int($SInfo($K,NSMP) / $Rep) + 1]
         }
      }
   }

#
#  Determine the number of ancillary elements in each type.  Sensor
#  ancillary values are per column of sensor set data
#

   set $SInfo($K,NSANC) 0
   set $SInfo($K,NGANC) 0
   for {set I 0} {$I < $SInfo($G,ANUM) } {incr I } {
      switch -exact -- [lindex $SInfo($G,ATARGET) $I] {
         0 { incr SInfo($K,NSANC) [lindex $SInfo($Ka) $I]  }
         2 { incr SInfo($K,NGANC) [lindex $SInfo($Ka) $I]  }
      }
   }

#
#  Determine the byte size of the general and sensor ancillary storage areas
#  Note that the sensor ancillary elements may not be byte aligned (pre V2.2)
#  so we need to account for this.
# 
   
   set TC [expr $SInfo($K,NSEN) * $SInfo($K,NCOLS)]
   set SInfo($K,NSANC) [expr $SInfo($K,NSANC) * $TC]
   set SInfo($S,AGBYTES) [expr $SInfo($G,AGBLEN) * $SInfo($K,NGANC)]
   set SInfo($S,ASBYTES) [expr $SInfo($K,NSANC) * $SInfo($G,ASBLEN)]

}
