package provide TclUDF 1.0

proc UDFMathExt { K N Op Data BufN } {
   global SInfo ExDa  OutSideMin ToRad ExPhi$N
   
   set T $K,TM

   upvar $Data X

   set Beg [expr $BufN * $ExDa($N,NSMP)]
   set End [expr $ExDa($N,NSMP) + $Beg]
   switch -exact -- $Op {
       1  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr exp($X($I))]
             }
          }
       2  {  for {set I $Beg} {$I < $End } {incr I} {
                if { $X($I) > 0.0 } {
                   set X($I) [expr log($X($I))]
                } else { set X($I) $OutSideMin }
             }
          }
       3  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr pow(10.0, $X($I))]
             }
          }
       4  {  for {set I $Beg} {$I < $End } {incr I} {
                if { $X($I) > 0.0 } {
                   set X($I) [expr log10($X($I))]
                } else { set X($I) $OutSideMin }
             }
          }
       5  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr pow(2.0, $X($I))]
             }
          }
       6  {  for {set I $Beg} {$I < $End } {incr I} {
                if { $X($I) >= 0.0 } {
                   set X($I) [expr sqrt($X($I))]
                } else { set X($I) $OutSideMin }
             }
          }
       7  {  for {set I $Beg} {$I < $End } {incr I} {
                set A [expr $ToRad * $X($I)]
                set X($I) [expr cos($A)]
             }
          }
       8  {  for {set I $Beg} {$I < $End } {incr I} {
                set A [expr $ToRad * $X($I)]
                set X($I) [expr sin($A)]
             }
          }
       9  {  for {set I $Beg} {$I < $End } {incr I} {
                set A [expr $ToRad * $X($I)]
                set X($I) [expr tan($A)]
             }
          }
      10  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr acos($X($I))]
             }
          }
      11  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr asin($X($I))]
             }
          }
      12  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr atan($X($I))]
             }
          }
      13  {  for {set I $Beg} {$I < $End } {incr I} {
                if { $X($I) != 0.0 } {
                   set X($I) [expr 1.0 / $X($I)]
                } else { set X($I) $OutSideMin }
             }
          }
      14  {  set dT [expr $SInfo($T,ACCMS) * 1.e-3 + $SInfo($T,ACCNS) * 1.e-9]
             for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr $X($I) * $dT]
             }
          }
      15  {  set dT [expr $SInfo($T,ACCMS) * 1.e-3 + $SInfo($T,ACCNS) * 1.e-9]
             for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr $X($I) / $dT]
             }
          }
      16  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr -$X($I)]
             }
          }
      17  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr $X($I) * $X($I)]
             }
          }
      18  {  set TmP ExPhi$N
             upvar 0 $TmP A
             set J 0
             set K $ExDa($N,NSMP)
             for {set I $Beg} {$I < $End } {incr I} {
                set dA [expr ($A($J) + $A($K)) / 2.0 ]
                set TmP [expr $dA - $A($J)]
                if {($TmP > 60.0) || ($TmP < -60.0) } {
                   set dA [expr $dA + 180.0]
                }
                set X($I) [expr $X($I) - $dA]
                if {$X($I) < 0.0  } { set X($I) [expr $X($I) + 360.0] }
                incr J
                incr K
             }
          }
      19  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr abs($X($I))]
             }
          }
      20  {  set TmP ExPhi$N
             upvar 0 $TmP A
             set J 0
             for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr $X($I) + $A($J)]
                if {$X($I) < 0.0  } { 
                   set X($I) [expr $X($I) + 360.0]
                } elseif { $X($I) >= 360.0  } { 
                   set X($I) [expr $X($I) - 360.0]
                }
                incr J
             }
          }
      21 -
      26  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr int($X($I))]
             }
          }
      22  {  for {set I $Beg} {$I < $End } {incr I} {
                set V [expr int($X($I)] 
                set S [expr ($V >> 7) & 1] 
                if {$S == 0} { 
                   set X($I) $V 
                } else { set X($I) [expr -256 + $V] }
             }
          }
      23  {  for {set I $Beg} {$I < $End } {incr I} {
                set V [expr int($X($I)] 
                set S [expr ($V >> 15) & 1] 
                if {$S == 0} { 
                   set X($I) $V 
                } else { set X($I) [expr -65536 + $V] }
             }
          }
      24  {  for {set I $Beg} {$I < $End } {incr I} {
                set V [expr int($X($I)] 
                set S [expr ($V >> 11) & 1] 
                if {$S == 0} { 
                   set X($I) $V 
                } else { set X($I) [expr -4096 + $V] }
             }
          }
      25  {  for {set I $Beg} {$I < $End } {incr I} {
                set V [expr int($X($I)] 
                set S [expr ($V >> 23) & 1] 
                if {$S == 0} { 
                   set X($I) $V 
                } else { set X($I) [expr -16777216 + $V] }
             }
          }
      27  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr $X($I) - int($X($I)] 
             }
          }
      28  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr ceil($X($I)] 
             }
          }
      29  {  for {set I $Beg} {$I < $End } {incr I} {
                set X($I) [expr floor($X($I)] 
             }
          }
      default {
          }
   }
}
