#package provide TclUDF_C 1.0
package provide TclUDF 1.0

proc UDFMath { K N Bufs uI } {
   global SInfo ExDa Tbls$K ExMode$N
   
   set G $K,GN
   set P $K,PT

   upvar $Bufs V

   set tN   [lindex $uI 0]
   set IBuf [lindex $uI 1]
   set OBuf [lindex $uI 2]
   set Op   [lindex $uI 4]
   set TOp  [lindex $uI 5]
   set HBuf [lindex $uI 6]

   set nTe  [lindex [lindex $SInfo($K,TELEM) $tN] $ExDa($N,SEN)]

   if {[llength [lindex $SInfo($K,TCMODE) $tN]] == 0 } {
      set Off [lindex [lindex $SInfo($K,TOFF) $tN] $ExDa($N,SEN)]
   } else {
      set Mode [lindex [lindex $SInfo($K,TCMODE) $tN] $ExDa($N,SEN)]
      if {$Mode < 0 } {
         set Off [lindex [lindex $SInfo($K,TOFF) $tN] $ExDa($N,SEN)]
      } else {
         set TmP ExMode$N
         upvar $TmP Y
         set Off [lindex [lindex $SInfo($K,TCOFF) $tN] $ExDa($N,SEN)]
         incr Off $Y($Mode)
         set Off [lindex [lindex $SInfo($K,TCTOTBL) $tN] $Off]
      }
   }

   set TOff [expr [lindex $SInfo($P,TOTBL) $tN] + $Off]
   set J [expr $OBuf * $ExDa($N,NSMP)]
   switch -exact -- $Op {
      =   { set Cmd {set V($J) [UDFtblApply $K $TOp $TOff $nTe $V($L)] } }
      +   -
      -   -
      *   -
      /   { set Cmd {set V($J) [expr $V($I) $Op \
                               [UDFtblApply $K $TOp $TOff $nTe $V($L)]] }
          }
      P   { set Cmd {set V($J) [expr pow ($V($I), \
                               [UDFtblApply $K $TOp $TOff $nTe $V($L)]] }
          }
      default  { set Cmd {set V($J) [expr int($V($I)) $Op \
                            int([UDFtblApply $K $TOp $TOff $nTe $V($L)])] }
          }
   }  

   if {$IBuf < 0 } { set IBuf 0 }
   set L [expr $HBuf * $ExDa($N,NSMP)]
   set Beg [expr $IBuf * $ExDa($N,NSMP)]
   set End [expr $ExDa($N,NSMP) + $Beg]
   for {set I $Beg} {$I < $End } {incr I ; incr J ; incr L} { eval $Cmd }
}
