package provide TclUDF 1.0

proc ReadPIDF { Key { N 0 } } {
   global Pidf$N UDFPaths SInfo

   set TmP Pidf$N
   upvar 0 $TmP P

   if [info exists P] {
      if { $Key == $P(Key) } { return 0 }
      unset P
   } 

   set PmEiV [UDFinvKey $Key] 
   UDFdirPaths [lindex $PmEiV 0] [lindex $PmEiV 1] \
               [lindex $PmEiV 2] [lindex $PmEiV 3]

   set Fname [file join $UDFPaths(0) [lindex $PmEiV 4].pidf.v2]
   if ![file exist $Fname] { 
      if ![string match OFF $SInfo(AutoPr)] { 
          UDFfilePromote SEARCHP $Key 1900 1 0 2500 1 0 
      }
   }
   if [catch {open $Fname r} fd] {
      puts stderr "CANNOT OPEN $Fname"
      return -1
   }

   set field ""
   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([A-Za-z]*)([0-9]*)(.*)}

   set P(PlotAvail) 0x3 
   set P(DataMask)  0x10
   set P(Blocking)  0
   set P(InstDeps)  5
   set P(Cyclic)    N
   set P(MinMax)    [list -1 -1 -1 -1 -1 -1 ]
   set P(NBinSets)  -1
   set P(NUnits)    0
   set P(NModes)    0
   set P(NSens)     0
   set P(NScans)    0
   set P(NAncs)     0
   set P(NdQ)       0
   set P(NPhase)    0
   set P(NPitch)    0
   set P(SenType)   S
   set P(GrpName)   ""
   set P(Version)   2.0
   set P(Institute) ""
   set P(Project)   ""
   set P(Mission)   ""
   set P(Exper)     ""
   set P(Inst)      ""
   set P(Vinst)     ""

   while { [gets $fd line] >= 0} {
      regexp "$P1" $line M type field V com
      if ![string match struct* $type] { 
         switch -glob -- $field {
            num_groups*      {  set P(NGroups) $V }
            group_name*      {  regexp "$P2" $line M type field name com
                                lappend P(GrpName) $name
                             }
            plot_avail_flag* {  set P(PlotAvail)  $V }
            data_type_mask*  {  set P(DataMask)   $V }
            instrument_dep*  {  set P(InstDeps)   $V }
            cyclic*          {  set P(Cyclic)  [string trim $V "'"] }
            blocking*        {  set P(Blocking)   $V }
            sen_type*        {  set P(SenType) [string trim $V "'"] }
            phi_min*         {  set P(MinMax) [lreplace $P(MinMax) 0 0 $V] }
            phi_max*         {  set P(MinMax) [lreplace $P(MinMax) 1 1 $V] }
            theta_min*       {  set P(MinMax) [lreplace $P(MinMax) 2 2 $V] }
            theta_max*       {  set P(MinMax) [lreplace $P(MinMax) 3 3 $V] }
            scan_min*        {  set P(MinMax) [lreplace $P(MinMax) 4 4 $V] }
            scan_max*        {  set P(MinMax) [lreplace $P(MinMax) 5 5 $V] }
            num_bin_sets*    {  set P(NBinSets)   $V }
            version*         {  set P(Version)    $V }
            institution*     {  set P(Institute)  $V }
            project*         {  set P(Project)    $V }
            mission*         {  set P(Mission)    $V }
            experiment*      {  set P(Exper)      $V }
            instrument*      {  set P(Inst)       $V }
            vinst*           {  set P(VInst)      $V }
         }
      } else {
         regexp "$P3" $line M type field pos com
         switch -glob -- $field {
            Unit*       { UDFpidfUnit   $N $fd }
            Sensor*     { UDFpidfSensor $N $fd }
            Mode*       { UDFpidfMode   $N $fd }
            Scan*       { UDFpidfScan   $N $fd }
            CalSet*     { UDFpidfAnc    $N $fd }
            DataQual*   { UDFpidfDQual  $N $fd }
            SpinAngle*  { UDFpidfPhase  $N $fd }
            PitchAngle* { UDFpidfPitch  $N $fd }
         }
      }
   }

   set P(NGroups) [llength $P(GrpName)]

   close $fd
   set P(Key) $Key
   return 1
}
