/*  The C equivalent of UDFtimeComps,  It consists of a straignt C          */
/*      interface                                                           */
/*                                                                          */
/*  There are 2 OBJV elements - last two optional.  These are:              */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"
#include "TudfAnsi.h"

int TimeComps (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   register ByTe_1 *bP;
   ByTe_4 tP[4];
   ReaL_8 Ms;
   ByTe_4 LatMs, SRMs, SsRMs;
   ByTe_4 LatNs, SRNs, SsRNs;
   ByTe_4 AccMs, AccNs;
   ByTe_4 SmpMs, SmpNs;
   ByTe_4 ColMs, ColNs;
   ByTe_4 RowMs, RowNs;
   ByTe_2 TrC, TrP, TcP;
   ByTe_2 DrC, DrP, DcP;
   ByTe_4 tS, sMode, nSeN, nCoL, TotC, nSmP;
   int    Len;
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rVO;

   ByTe_1 *kV, VarN[40];
   u_ByTe_1 *cP[2];

/* MAKE sure that all the IO parameters are present                         */

   if (objc < 2 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFtimeComps kV" );
     return TCL_ERROR;
   }

/* GET required the inputs                                                  */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);

/* GET pointers to the header and data records                              */

   BlockVar (tI, 0, kV, "", cP, (ByTe_1 *)NULL, 0, (Tcl_Obj *)NULL);

/* SET pointer to the header timing information and get the accum time      */
/*     scaling along with the total nuber of columns and sensors in the     */
/*     sensor set                                                           */

   bP = (ByTe_1 *)(cP[0] + 6);
   tS = *(ByTe_1 *)(cP[0] + 4);
   nSeN = *(ByTe_2 *)(cP[0] + 22);
   nSmP = *(ByTe_2 *)(cP[0] + 24);
   CGetVar (tI, "SInfo", kV, ",NCOLS",  'L', (ByTe_1 *)&nCoL);

   TotC = nSeN * nCoL;

/* COMPUTE some initial time components                                     */

   memcpy ((void *)tP, (void *)bP, 16);
   LatMs = tP[1] / 1000;
   LatNs = (tP[1] % 1000) * 1000;
   SRMs  = tP[2] / 1000;
   SRNs  = (tP[2] % 1000) * 1000;
   SsRMs = tP[3] / 1000;
   SsRNs = (tP[3] % 1000) * 1000;

   Ms = 1000.0 * *tP * pow(10.0, (ReaL_8)tS); 
   AccMs = (ByTe_4)Ms;
   AccNs = (ByTe_4)(fmod(Ms,1) * 1000000.0);

/* SET up the time between consecutive measurements                         */

   SmpMs = AccMs + LatMs;
   SmpNs = AccNs + LatNs;

/* SET up the row/col parallel/sequential timing flags                      */

   CGetVar (tI, "SInfo", kV, ",GN,SENMODE",  'L', (ByTe_1 *)&sMode);
   TrC = 1 - sMode/4;
   TrP = 1 - (sMode % 4) / 2;
   TcP = 1 - (sMode % 2);
   DrC = 1 - TrC;
   DrP = 1 - TrP;
   DcP = 1 - TcP;

/* SET up the time between consecutive columns in the sensor set            */
   
   ColMs = TcP * (TrC * SmpMs + DrC * ((TotC * TrP + DrP) * SmpMs + SRMs));
   ColNs = TcP * (TrC * SmpNs + DrC * ((TotC * TrP + DrP) * SmpNs + SRNs));
               
/* SET up the time between consecutive rows in the sensor set               */

   RowMs = TrP * (DrC * SmpMs + TrC * ((nSmP * TcP + DcP) * SmpMs + SRMs));
   RowNs = TrP * (DrC * SmpNs + TrC * ((nSmP * TcP + DcP) * SmpNs + SRNs));

/* LAST - put all these values into their respective TCL storage slots.     */

   rVO = Tcl_NewObj();
   Tcl_UpVar(tI, "#0", "SInfo", "sI", 0);

   sprintf (VarN, "%s,TM,LATMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, LatMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,LATNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, LatNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SRSTMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SRMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SRSTNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SRNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SSRSTMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SsRMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SSRSTNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SsRNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,ACCMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, AccMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,ACCNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, AccNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SMPMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SmpMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,SMPNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, SmpNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,COLMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, ColMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,COLNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, ColNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,ROWMS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, RowMs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   sprintf (VarN, "%s,TM,ROWNS", kV);
   rVO = Tcl_DuplicateObj(rVO);
   Tcl_SetIntObj (rVO, RowNs);
   Tcl_SetVar2Ex(tI, "sI", VarN, rVO, Flg);

   return TCL_OK;
}
