/*  The C equivalent of UDFretVar,  It consists of a TCL interface over     */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 5 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF variable to return (VaR)                           */
/*     OBJV[3]:  The returned variable                                      */
/*     OBJV[4]:  How the variable is to be returned                         */
/*                  0 - as a list of values                                 */
/*                  1 - as an array of values                               */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int RetVar (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
    int      rFmt;
    int      rEt; 
    void     *rP;
    ByTe_4   Len = 1, Off;
    int      Dummy[2];
    u_ByTe_1  *cP[2];
    ByTe_1   Type = 's';
    ByTe_1   Index[30];
    ByTe_1   *kV, *VaR;

/* If the data requested is not available this is the dummy return */

    Dummy[0] = 0;
    Dummy[1] = 1;

/* Make sure that all the IO parameters are present */

    if (objc < 4 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFretVal kV VAR ...");
      return TCL_ERROR;
    }

/* Get the non-array inputs                                                 */
 
    kV  = Tcl_GetStringFromObj (objv[1], (int *)NULL);
    VaR = Tcl_GetStringFromObj (objv[2], (int *)NULL);
    if ( objc == 5 ) {
       Tcl_GetIntFromObj (tI, objv[4], &rFmt);
    } else { rFmt = 0; }

/* Get the header and data record data                                   */


   BlockVar (tI, 0, kV, "", cP, (ByTe_1 *)NULL, 0, (Tcl_Obj *)NULL);

/* Convert the string return item name to an integer value                */

    Len = 1;
    switch (VaR[0]) {
        case 'C':
          if (strcmp(VaR, "COLDATA") == 0 ) { 
             rP = (void *)(cP[0] + 26);
             Len = 3;
          }
        break;
        case 'D':
          if (strcmp(VaR, "DAY") == 0 ) { rP = (void *)(cP[0] + 2); }
        break;
        case 'H':
          if (strcmp(VaR, "HTIMES") == 0 ) { 
             rP = (void *)(cP[0] + 6);
             Type = 'l';
             Len = 4;
         }
        break;
        case 'L':
          if (strcmp(VaR, "LEADCOL") == 0 ) { 
             CGetVar (tI, "SInfo", kV, ",GN,SMPID", 'I', (ByTe_1 *)&rEt);
             if (rEt == 3 ) { rP = (void *)(cP[0] + 28); }
          }
        break;
        case 'M':
          if (strcmp(VaR, "MODES") == 0 ) { 
             Type = 'c';
             Len = *(u_ByTe_1 *)(cP[0] + 5);
             if (Len > 0) {
                CGetVar (tI, "SInfo", kV, ",PT,TOMODE", 'L', (ByTe_1 *)&Off);
                rP = (void *)(cP[0] + Off);
             }
          }
        break;
        case 'N':
          if (strcmp(VaR, "NSS") == 0 ) { 
             Type = 'L';
             sprintf(Index, "%s,PT,TONSS", kV);
             CGetVar (tI, "SInfo", kV, ",PT,TONSS", 'L', (ByTe_1 *)&Off);
             rP = (void *)(cP[1] + Off);
          } else if (strcmp(VaR, "NSMP") == 0 ) {
             rP = (void *)(cP[0] + 24);
          } else if (strcmp(VaR, "NMODES") == 0 ) {
             Type = 'c';
             rP = (void *)(cP[0] + 5);
          } else if (strcmp(VaR, "NSEN") == 0 ) {
             rP = (void *)(cP[0] + 22);
          }
        break;
        case 'Q':
          if (strcmp(VaR, "QUAL") == 0 ) { 
             Len = *(u_ByTe_2 *)(cP[0] + 22);
             CGetVar (tI, "SInfo", kV, ",PT,TOQUAL", 'L', (ByTe_1 *)&Off);
             rP = (void *)(cP[0] + Off);
             Type = 'c';
          }
        break;
        case 'S':
          if (strcmp(VaR, "SCAN") == 0 ) { 
             CGetVar (tI, "SInfo", kV, ",GN,SMPID", 'I', (ByTe_1 *)&rEt);
             Len = ( rEt == 2 ) ? 1 : *(u_ByTe_2 *)(cP[0] + 24);
             CGetVar (tI, "SInfo", kV, ",PT,TOSCAN", 'L', (ByTe_1 *)&Off);
             rP = (void *)(cP[0] + Off);
          } else if (strcmp(VaR, "SENS") == 0 ) {
             Len = *(u_ByTe_2 *)(cP[0] + 22);
             CGetVar (tI, "SInfo", kV, ",PT,TOSEN", 'L', (ByTe_1 *)&Off);
             rP = (void *)(cP[0] + Off);
          } else if (strcmp(VaR, "SPIN") == 0 ) {
             rP = (void *)(cP[1] + 4);
             Type = 'L';
          }
        break;
        case 'T':
          if (strcmp(VaR, "TOTCOL") == 0 ) { 
             CGetVar (tI, "SInfo", kV, ",GN,SMPID", 'I', (ByTe_1 *)&rEt);
             if (rEt == 3 ) { 
                rP = (void *)(cP[0] + 30); 
             } else { rP = (void *)(&Dummy[1]); } 
          } else if (strcmp(VaR, "TSCALE") == 0 ) {
             Type = 'C';
             rP = (void *)(cP[0] + 4);
          } else if (strcmp(VaR, "TIME") == 0 ) {
             rP = (void *)(cP[1]);
             Type = 'L';
          }
        break;
        case 'Y':
          if (strcmp(VaR, "YRDY") == 0 ) { 
             Len = 2;
             rP = (void *)(cP[0]);
          } else if (strcmp(VaR, "YEAR") == 0 ) {
             rP = (void *)(cP[0]);
          }
        break;
        case 'Z':
          if (strcmp(VaR, "ZERO") == 0 ) { 
             rP = (void *)(cP[1] + 8); 
             Type = 'L';
          }
        break;
    }

/* Return the data as either a list (rFmt = 0) or an array (rFmt = 1)       */
/*  of values                                                               */

    if ( rP == 0 ) { rP = (void *)Dummy; }


    if ( rFmt == 0 ) {
        CArrayToList (tI, objv[3], rP, Len, Type); 
    } else { CArrayToTcl (tI, objv[3], rP, Len, 0, Type); }

    return TCL_OK;
}
